/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mortbay.xml.XmlParser;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static final Logger logger = Logger.getLogger(XmlUtils.class.getName());

    static String getText(XmlParser.Node node) throws AppEngineConfigException {
        String value;
        Object child = node.get(0);
        if (child == null) {
            value = "";
        } else {
            if (!(child instanceof String)) {
                String msg = "Invalid XML: String content expected in node '" + node.getTag() + "'.";
                logger.log(Level.SEVERE, msg);
                throw new AppEngineConfigException(msg);
            }
            value = (String)child;
        }
        return value.trim();
    }

    static XmlParser.Node parse(InputStream is) {
        XmlParser xmlParser = new XmlParser();
        try {
            return xmlParser.parse(is);
        }
        catch (IOException e) {
            String msg = "Received IOException parsing the input stream.";
            logger.log(Level.SEVERE, msg, e);
            throw new AppEngineConfigException(msg, e);
        }
        catch (SAXException e) {
            String msg = "Received SAXException parsing the input stream.";
            logger.log(Level.SEVERE, msg, e);
            throw new AppEngineConfigException(msg, e);
        }
    }
}

