// Chattr - Twitter client on .NET
//
// Copyright (c) 2007 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: IPopup.cs 79 2007-12-23 21:32:05Z ichi $

using System;
using System.Collections.Generic;
using System.Text;

namespace Chattr
{
    class IPopup
    {
        private long m_ID;
        private int m_Flags;
        private string m_User;
        private string m_Text;

        public IPopup()
        {
            m_ID = -1;
            m_Flags = 0;
            m_Text = "";
            m_User = "";
        }

        public IPopup(long id, int flags, string user, string text)
        {
            m_ID = id;
            m_Flags = flags;
            m_User = user;
            m_Text = text;
        }

        public override string ToString()
        {
            return m_User + ": " + m_Text;
        }

        public long ID
        {
            get
            {
                return m_ID;
            }
            set
            {
                m_ID = value;
            }
        }

        public int Flags
        {
            get
            {
                return m_Flags;
            }
            set
            {
                m_Flags = value;
            }
        }

        public string User
        {
            get
            {
                return m_User;
            }
            set
            {
                m_User = value;
            }
        }

        public string Text
        {
            get
            {
                return m_Text;
            }
            set
            {
                m_Text = value;
            }
        }
    }
}
