//
//  core.h
//  AI003
//
//  Created by 西田　耀 on 13/01/28.
//  Copyright (c) 2013年 Hikaru Nishida. All rights reserved.
//

#ifndef AI003_core_h
#define AI003_core_h

#include "chnlib.h"

#define AI_CONFIG_FILE_NAME "config.txt"
#define AI_INPUT_HISTORY_MAX    10
#define AI_EVENT_COUNT_0        10

#define AI_SW_Delimiter_Colon   1
#define AI_SW_Delimiter_Comma   2
#define AI_SW_Delimiter_Plus    3
#define AI_SW_Bracket_Start     4
#define AI_SW_Bracket_End       5

typedef struct AI_WORKING_SET AI_WorkingSet;
struct AI_WORKING_SET {
    CHNLIB_UIPArray *SystemWordList0;   //データ解釈用区切り文字列を格納
    CHNLIB_UIPArray *SystemWordList1;   //記憶単位のデータ種類を表す文字列を格納
    CHNLIB_UIPArray *SystemWordList2;   //数字に使用する文字列を格納
    CHNLIB_UIPArray *RootWordList;      //あらゆる文字列のStringを保持する。data32は単語カウント。
    CHNLIB_UIPArray *RootMemory;        //記憶データを保持する。
    CHNLIB_UIPArray *InputHistory;
};

//@main.c
extern AI_WorkingSet WorkingSet;
void AI_Think_LearnWordFromInputString(CHNLIB_String *input);
CHNLIB_UIPArray *AI_Think_SlideLookUpWordByHistory(CHNLIB_String *input);
CHNLIB_UIPArray *AI_Think_WordList_GetSortedByLength(const CHNLIB_UIPArray *wordlist);
void AI_Think_WordList_SetLengthToData32(CHNLIB_UIPArray **wordlist);
void AI_System_InitializeSystemWorkingSet(void);

//@memory.c
int AI_Memory_AddRootWordData(CHNLIB_String *tag);
int AI_Memory_AddRootWordData_IsDuplicated(const void *listtag, const void *newtag);
int AI_Memory_AddRootMemoryData(CHNLIB_UIPArray *tag);
int AI_Memory_AddRootMemoryData_IsDuplicated(const void *listtag, const void *newtag);
void AI_System_LoadMemory(const char configfilename[]);
void AI_System_SaveMemory_RootWordList(const char configfilename[]);
void AI_System_SaveMemory_RootMemory(const char memlistfilename[]);

//@wlfilter.c
int AI_Think_CandidateWordList_Filter00(CHNLIB_UIPArray **candidatewordlist);
int AI_Think_CandidateWordList_Filter01(CHNLIB_UIPArray **candidatewordlist, int length);
int AI_Think_CandidateWordList_Filter02(CHNLIB_UIPArray **candidatewordlist, uint count);

#endif
