<?php
//CKEditor RichText Editor Plugin v3.0.0-alpha

// getCKEditorSettings function
if (!function_exists('getCKEditorSettings'))
{
	function getCKEditorSettings($_lang,
	                             $path,
	                             $manager_language='english',
	                             $use_editor,
	                             $toolbarset,
	                             $toolbarcustom,
	                             $autolang,
	                             $displayStyle,
	                             $xmlstyle)
	{
		// language settings
		if(!@include_once($path.'/lang/'.$manager_language.'.inc.php'))
		    @include_once($path.'/lang/english.inc.php');

		$display = $use_editor==1 ? $displayStyle : 'none';
		$cusDisplay = $use_editor==1 && $toolbarset=='custom' ? $displayStyle : 'none';

		$arrToolbar['basic']    = $_lang['ckeditor_toolbar_basic'];
		$arrToolbar['standard'] = $_lang['ckeditor_toolbar_standard'];
		$arrToolbar['advanced'] = $_lang['ckeditor_toolbar_advanced'];
		$arrToolbar['custom']   = $_lang['ckeditor_toolbar_custom'];
		foreach ($arrToolbar as $key=>$value)
		{
				$toolbarOptions .= "					<option value=\"".$key."\"".($key == $toolbarset ? " selected=\"selected\"" : "").">".$value."</option>\n";
		}
		$toolbarcustom = isset($toolbarcustom) ? htmlspecialchars($toolbarcustom) : "['Bold','Italic','Underline','-','Link','Unlink']";
		$autolang = !empty($autolang) ? $autolang : "disabled";
		$autoNo = ($autolang=='disabled' || !empty($autolang)) ? 'checked="checked"' : '';
		$autoYes = $autolang=='enabled' ? 'checked="checked"' : '';
		$xmlstyle = !empty($xmlstyle) ? htmlspecialchars($xmlstyle) : "";

		$str = '		<table id="editorRow_CKEditor" style="width:inherit;" border="0" cellspacing="0" cellpadding="3">' . PHP_EOL;
		$str .= '		  <tr class="row1" style="display: ' . $display . ';">' . PHP_EOL;
		$str .= '            <td colspan="2" class="warning" style="color:#707070; background-color:#eeeeee"><h4>' . $_lang["CKEditor_settings"] . '<h4></td>' . PHP_EOL;
		$str .= '          </tr>' . PHP_EOL;
		$str .= '          <tr class="row1" style="display: ' . $display . '">' . PHP_EOL;
		$str .= '            <td nowrap class="warning"><b>' . $_lang["ck_editor_autolang_title"] . '</b></td>' . PHP_EOL;
		$str .= '            <td> <input onChange="documentDirty=true;" type="radio" name="ck_editor_autolang" value="enabled" ' . $autoYes . ' />' . PHP_EOL;
		$str .= '              ' . $_lang["yes"] . '<br />' . PHP_EOL;
		$str .= '              <input onChange="documentDirty=true;" type="radio" name="ck_editor_autolang" value="disabled" ' . $autoNo . ' />' . PHP_EOL;
		$str .= '              ' . $_lang["no"] . ' </td>' . PHP_EOL;
		$str .= '          </tr>' . PHP_EOL;
		$str .= '          <tr class="row1" style="display: ' . $display . '">' . PHP_EOL;
		$str .= '            <td width="200">&nbsp;</td>' . PHP_EOL;
		$str .= '            <td class="comment">' . $_lang["ck_editor_autolang_message"] . '</td>' . PHP_EOL;
		$str .= '          </tr>' . PHP_EOL;
		$str .= '		  <tr class="row1" style="display: ' . $display . '">' . PHP_EOL;
		$str .= '            <td colspan="2"><div class="split"></div></td>' . PHP_EOL;
		$str .= '          </tr>' . PHP_EOL;
		$str .= '          <tr class="row1" style="display: ' . $display . '">' . PHP_EOL;
		$str .= '            <td nowrap class="warning"><b>' . $_lang["ck_editor_style_title"] . '</b></td>' . PHP_EOL;
		$str .= '            <td><input onChange="documentDirty=true;" type="text" maxlength="255" style="width: 300px;" name="ck_editor_style" value="' . $xmlstyle . '" />' . PHP_EOL;
		$str .= '			</td>' . PHP_EOL;
		$str .= '          </tr>' . PHP_EOL;
		$str .= '          <tr class="row1" style="display: ' . $display . '">' . PHP_EOL;
		$str .= '            <td width="200">&nbsp;</td>' . PHP_EOL;
		$str .= '            <td class="comment">' . $_lang["ck_editor_style_message"] . '</td>' . PHP_EOL;
		$str .= '          </tr>' . PHP_EOL;
		$str .= '		  <tr class="row1" style="display: ' . $display . '">' . PHP_EOL;
		$str .= '            <td colspan="2"><div class="split"></div></td>' . PHP_EOL;
		$str .= '          </tr>' . PHP_EOL;
		$str .= '          <tr class="row1" style="display: ' . $display . '">' . PHP_EOL;
		$str .= '            <td nowrap class="warning"><b>' . $_lang["ck_editor_toolbar_title"] . '</b></td>' . PHP_EOL;
		$str .= '            <td>' . PHP_EOL;
		$str .= '            <select name="ck_editor_toolbar" onChange="documentDirty=true;if(this.selectedIndex==3) showHide(/ck_customset/,1); else showHide(/ck_customset/,0);">' . PHP_EOL;
		$str .= $toolbarOptions . PHP_EOL;
		$str .= '			</select>' . PHP_EOL;
		$str .= '			</td>' . PHP_EOL;
		$str .= '          </tr>' . PHP_EOL;
		$str .= '          <tr class="row1" style="display: ' . $display . '">' . PHP_EOL;
		$str .= '            <td width="200">&nbsp;</td>' . PHP_EOL;
		$str .= '            <td class="comment">' . $_lang["ck_editor_toolbar_message"] . '</td>' . PHP_EOL;
		$str .= '          </tr>' . PHP_EOL;
		$str .= '		  <tr class="row1" style="display: ' . $display . '">' . PHP_EOL;
		$str .= '            <td colspan="2"><div class="split"></div></td>' . PHP_EOL;
		$str .= '          </tr>' . PHP_EOL;
		$str .= '          <tr id="ck_customset1" class="row3" style="display: ' . $cusDisplay . '">' . PHP_EOL;
		$str .= '            <td nowrap class="warning"><b>' . $_lang["ck_editor_custom_toolbar"] . '</b></td>' . PHP_EOL;
		$str .= '            <td>' . PHP_EOL;
		$str .= '            <input name="ck_editor_custom_toolbar" type="text" style="width:300px;" maxlength="65000" onChange="documentDirty=true;" value="' . $toolbarcustom . '" />' . PHP_EOL;
		$str .= '			</td>' . PHP_EOL;
		$str .= '          </tr>' . PHP_EOL;
		$str .= '          <tr id="ck_customset2" class="row3" style="display: ' . $cusDisplay . '">' . PHP_EOL;
		$str .= '            <td width="200">&nbsp;</td>' . PHP_EOL;
		$str .= '            <td class="comment">' . $_lang["ck_editor_custom_message"] . '</td>' . PHP_EOL;
		$str .= '          </tr>' . PHP_EOL;
		$str .= '		  <tr id="ck_customset3" class="row3" style="display: ' . $cusDisplay . '">' . PHP_EOL;
		$str .= '            <td colspan="2"><div class="split"></div></td>' . PHP_EOL;
		$str .= '          </tr>' . PHP_EOL;
		$str .= '		</table>' . PHP_EOL;
		$str .= '<script>' . PHP_EOL;
		$str .= 'alert(' . $toolbarset . ');' . PHP_EOL;
		$str .= '</script>' . PHP_EOL;
return $str;
	}
}

// getTinyMCEScript function
if (!function_exists('getCKEditorScript'))
{
	function getCKEditorScript($elementList,
	                           $toolbarset,
	                           $toolbarcustom,
	                           $width,
	                           $height,
	                           $language,
	                           $frontend,
	                           $base_url,
	                           $editor_css_path,
	                           $use_browser,
	                           $autoLang,
	                           $editorstyle,
	                           $pluginfolder,
	                           $webuser)
	{
	    $autoLang = ($autoLang == 'enabled' ? 'true': 'false');
	    $ckePath = $base_url. 'assets/plugins/' . $pluginfolder;
		$editor_css_path = !empty($editor_css_path) ? $editor_css_path : $ckePath . '/editor/css/ck_editorarea.css';
		$toolbarcustom = !empty($toolbarcustom) ? "var CKCustomToolbarSet = [ ".$toolbarcustom." ];" : "";
		$width = (!empty($width)) ? str_replace("px","",$width) : "100%";
		$height = (!empty($height)) ? str_replace("px","",$height) : "400";

		if($frontend=='false' || ($frontend=='true' && $webuser))
		{
			if($use_browser==1)
			{
				$allowrb = true;
			}
		}

		// build ck instances
        $elementList = split(",",$elementList);
        $connector_path = $base_url . 'manager/media/browser/mcpuk/connectors/php/connector.php';
        $mcpuk_path['base']  = $base_url . 'manager/media/browser/mcpuk/browser.php';
		$mcpuk_path['image'] = $mcpuk_path['base'] . '?Type=images&Connector=' . $connector_path . '&ServerPath=' . $base_url . '&editor=tinymce3&editorpath=' . $ckePath;
		$mcpuk_path['link']  = $mcpuk_path['base'] . '?Connector=' . $connector_path . '&ServerPath=' . $base_url . '&editor=tinymce3&editorpath=' . $ckePath;
		$mcpuk_path['flash'] = $mcpuk_path['base'] . '?Type=flash&Connector=' .  $connector_path . '&ServerPath=' . $base_url . '&editor=tinymce3&editorpath=' . $ckePath;
		foreach($elementList as $ckInstance)
		{
			$ckInstanceObj = "oCK" . $ckInstance;
			$ckInstances .= "<script language='javascript' type='text/javascript'>" . PHP_EOL;
			$ckInstances .= "CKEDITOR.replace( '" . $ckInstance . "'," . PHP_EOL;
			$ckInstances .= "{" . PHP_EOL;
			$ckInstances .= "filebrowserBrowseUrl      : '" . $mcpuk_path['base'] . "'," . PHP_EOL;
			$ckInstances .= "filebrowserImageBrowseUrl : '" . $mcpuk_path['image'] . "'," . PHP_EOL;
			$ckInstances .= "filebrowserFlashBrowseUrl : '" . $mcpuk_path['flash'] . "'," . PHP_EOL;
			$ckInstances .= '}' . PHP_EOL;
			$ckInstances .= ' );' . PHP_EOL;

			$ckInstances .= "</script>" . PHP_EOL;
		}

$script = <<<CK_SCRIPT
		<script language="javascript" type="text/javascript" src="{$base_url}assets/plugins/{$pluginfolder}/ckeditor/ckeditor.js"></script>
		<script language="javascript" type="text/javascript">
			function CKeditor_OnComplete(edtInstance) {
				if (edtInstance){ // to-do: add better listener
					edtInstance.AttachToOnSelectionChange(tvOnCKChangeCallback);
				}
			};

			function tvOnCKChangeCallback(edtInstance) {
				if (edtInstance) {
					elm = edtInstance.LinkedField;
					if(elm && elm.onchange) elm.onchange();
				}
			}
		</script>
{$ckInstances}
CK_SCRIPT;

		return $script;
	}
}
?>