/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */
 package jp.sourceforge.manganetwork.page;

import java.util.List;

import javax.persistence.EntityManager;

import jp.sourceforge.manganetwork.dao.EMF;
import jp.sourceforge.manganetwork.model.Book;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.Model;

public class BookSearchPage extends MenuApplicationPage {
	private Model searchBookNameModel;
	
	public BookSearchPage()
	{
		searchBookNameModel = new Model();
		add(createForm());		
	}

	private Component createForm() {
		Form form = new Form("form")
		{
			@Override
			protected void onSubmit() {
				
				EntityManager em = EMF.get().createEntityManager();
				List<Book> bookList = em.createQuery("select b from "+Book.class.getName()+" b").getResultList();
				
				for (Book book : bookList)
				{
					System.out.println(">>>BOOK.NAME : " + book.getName());
				}
				em.close();

				super.onSubmit();
			}			
		};
				
		form.add(new TextField("searchBookName", searchBookNameModel));
		return form;
	}
}
