/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */
 package jp.sourceforge.manganetwork.page;

import jp.sourceforge.manganetwork.model.User;
import jp.sourceforge.manganetwork.web.UserSession;

import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.Model;

public class LoginPage extends ApplicationPage {

	public LoginPage()
	{
		final TextField userNameTextField = new TextField("userName", new Model());
		final PasswordTextField passwordTextField = new PasswordTextField("password", new Model());

		Form form = new Form("form")
		{
			@Override
			protected void onSubmit() {
				super.onSubmit();
				
				if (userNameTextField.getModelObjectAsString().equals("admin") &&
					passwordTextField.getModelObjectAsString().equals("admin") )
				{
					User user = new User();
					user.setName("admin");
					
					((UserSession)getSession()).setUser(user);
					setResponsePage(HomePage.class);
				}
				else
				{
					error("ログインに失敗しました。");
				}
			}			
		};
		this.add(form);

		form.add(userNameTextField);
		form.add(passwordTextField);
	}
}

