/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*   ץץ                                                     */
/*   ARM C饤֥Ѵؿ                                                */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include <stdio.h>
#include <rt_misc.h>


/* ߥۥƥSWIֹ */
#define SemiSWI		0x123456


/* ʸϡʥߥۥƥ󥰡 */
__swi(SemiSWI) void _WriteC(unsigned op, char *c);
#define WriteC(c) _WriteC (0x3,c)

/* exitʥߥۥƥ󥰡 */
__swi(SemiSWI) void _Exit(unsigned op, unsigned except);
#define Exit() _Exit (0x18,0x20026)



/* ʸ */
int fputc(int ch, FILE *f)
{
    char tmp = ch;

    WriteC(&tmp);

    return ch;
}


/* ե륨顼 */
int ferror(FILE *f)
{
    return EOF;
}


/* ץλ */
void _sys_exit(int return_code)
{
    Exit();
}


/* ߥʥ */
void _ttywrch(int ch)
{
}



static unsigned int heap_area[4096];	/* malloc ѥҡץꥢ */

/* ҡ״ѥɥ쥹 */
__value_in_regs struct __initial_stackheap __user_initial_stackheap(
        unsigned R0, unsigned SP, unsigned R2, unsigned SL)
{
    struct __initial_stackheap config;
    
    config.heap_base  = (unsigned long)heap_area;
    config.heap_limit = (unsigned long)&heap_area[4096];
    config.stack_base = SP;

    return config;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
