/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ 顼ϥɥ                                        */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_alm.h"



/* 顼ϥɥư */
ER stp_alm(
		ID almid)	/* ưоݤΥ顼ϥɥIDֹ */
{
	T_KERNEL_ALMCB_RAM *almcb_ram;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( almid < KERNEL_TMIN_ALMID || almid > KERNEL_TMAX_ALMID )
	{
		return E_ID;
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	almcb_ram = KERNEL_ALMID_TO_ALMCB_RAM(almid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( almcb_ram == NULL )
	{
		mknl_unl_sys();		/* ƥΥå */
		return E_NOEXS;
	}
#endif
	
	/* ޥꥹȤ鳰 */
	kernel_rmv_tml((T_KERNEL_TIM *)almcb_ram);
	
	mknl_unl_sys();		/* ƥΥå */

	return E_OK;	
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
