/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ åХåե                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbf.h"



/* åХåե */
ER cre_mbf(
		ID           mbfid,		/* оݤΥåХåեIDֹ */
		const T_CMBF *pk_cmbf)	/* åХåե줿ѥåȤؤΥݥ */
{
	ER ercd;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mbfid < KERNEL_TMIN_MBFID || mbfid > KERNEL_TMAX_MBFID )
	{
		return E_ID;	/* ID */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* åХåեϿǽɤå */
#ifdef HOS_ERCHK_E_OBJ
	if ( KERNEL_MBFID_TO_MBFCB_RAM(mbfid) != NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_OBJ;	/* ϿѤ */
	}
#endif

	/* åХåե */
	ercd = kernel_cre_mbf(mbfid, pk_cmbf);
	
	mknl_unl_sys();	/* ƥΥå */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
