/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ᡼ܥå                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbx.h"



/* ᡼ܥåμ */
ER trcv_mbx(			
		ID    mbxid,		/* оݤΥ᡼ܥåIDֹ */
		T_MSG **pk_msg,		/* ᡼ܥååѥåȤƬ */
		TMO   tmout)		/* ॢȻ */
{
	const T_KERNEL_MBXCB_ROM *mbxcb_rom;
	T_KERNEL_MBXCB_RAM       *mbxcb_ram;
	T_MKNL_TCB *mtcb;
	T_MSG *msg;
	PRI   msgpri;
	ER    ercd;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mbxid < KERNEL_TMIN_MBXID || mbxid > KERNEL_TMAX_MBXID )
	{
		return E_ID;
	}
#endif
	
	/* ѥ᡼å */
#ifdef HOS_ERCHK_E_PAR 
	if ( tmout != TMO_FEVR && tmout < 0 )
	{
		return E_PAR;	/* ѥ᡼ */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ƥȥå */
#ifdef HOS_ERCHK_E_CTX
	if ( tmout != TMO_POL &&  mknl_sns_wai() )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_CTX;	/* ƥ */
	}
#endif

	mbxcb_ram = KERNEL_MBXID_TO_MBXCB_RAM(mbxid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mbxcb_ram == NULL )
	{
		mknl_unl_sys();		/* ƥΥå */
		return E_NOEXS;
	}
#endif

	mbxcb_rom = mbxcb_ram->mbxcb_rom;
	
	/* åͥٽ˸ */
	for ( msgpri = 0; msgpri <= mbxcb_rom->maxmpri - TMIN_MPRI; msgpri++ )
	{
		if ( mbxcb_rom->mprihd[msgpri] != NULL )
		{
			break;
		}
	}

	if ( msgpri <= mbxcb_rom->maxmpri - TMIN_MPRI )
	{
		/* ᡼ܥå˥ǡмФ */
		msg = mbxcb_rom->mprihd[msgpri];
		if ( msg == msg->next )		/* ǸΣĤʤ */
		{
			*pk_msg                   = msg;
			mbxcb_rom->mprihd[msgpri] = NULL;
		}
		else
		{
			*pk_msg   = msg->next;
			msg->next = msg->next->next;
		}
		ercd = E_OK;	/*  */
	}
	else
	{
		/* ᡼ܥåʤ */
		if ( tmout == TMO_POL )
		{
			/* ݡ󥰤ʤ¨ॢ */
			ercd = E_TMOUT;
		}
		else
		{
			/* Ԥ */
			mtcb = mknl_get_run_tsk();
			mknl_wai_tsk(mtcb, TTW_MBX);
			mknl_add_que(&mbxcb_ram->que, mtcb, mbxcb_ram->mbxcb_rom->mbxatr);	/* Ԥɲ */

			/* ̵ԤǤʤ */
			if ( tmout != TMO_FEVR )
			{
				mknl_add_tmout(mtcb, (RELTIM)tmout);	/* ॢȥ塼ɲ */
			}
			
			ercd = (ER)mknl_exe_dsp();	/* ǥѥåμ¹ */
			
			/* ǡǼ */
			if ( ercd == E_OK )
			{
				*pk_msg = (T_MSG *)mtcb->data;
			}
			
			mknl_exe_tex();		/* 㳰μ¹ */
		}
	}

	mknl_unl_sys();	/* ƥΥå */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
