/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǽ                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"


/* (IDֹ漫ưդ) */
ER_ID acre_tsk(
		const T_CTSK *pk_ctsk)	/* 줿ѥåȤؤΥݥ */
{
	ID tskid;
	ER ercd;

	mknl_loc_sys();	/* ƥΥå */

	/* IDθ */
	for ( tskid = KERNEL_TMAX_TSKID; tskid >= KERNEL_TMIN_TSKID; tskid-- )
	{
		if ( KERNEL_TSKID_TO_TCB_RAM(tskid) == NULL )
		{
			break;
		}
	}
	if ( tskid < KERNEL_TMIN_TSKID )
	{
		mknl_unl_sys();		/* ƥΥå */
		return E_NOID;		/* IDֹ­ */
	}
	
	/*  */
	ercd = kernel_cre_tsk(tskid, pk_ctsk);

	mknl_unl_sys();	/* ƥΥå */

	if ( ercd != E_OK )
	{
		return (ER_ID)ercd;	/* 顼ȯ */
	}

	return (ER_ID)tskid;		/*  */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
