/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ °Ʊǽ                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* εԤ(ॢȤ) */
ER tslp_tsk(
			TMO tmout)
{
	T_KERNEL_TCB_RAM *tcb_ram;
	ER ercd;

	/* ѥ᡼å */
#ifdef HOS_ERCHK_E_PAR 
	if ( tmout != TMO_FEVR && tmout < 0 )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ƥȥå */
#ifdef HOS_ERCHK_E_CTX
	if ( mknl_sns_wai() )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_CTX;	/* ƥ */
	}
#endif

	/* ȥ֥å */
	tcb_ram = kernel_get_run_tsk();

	/* ׵ᥭ塼󥰤Υå */
	if ( tcb_ram->wupcnt > 0 )
	{
		tcb_ram->wupcnt--;
		mknl_unl_sys();		/* ƥΥå */
		return E_OK;
	}

	/* ݡ󥰻ʤ饿ॢ */
	if ( tmout == TMO_POL )
	{
		mknl_unl_sys();		/* ƥΥå */
		return E_TMOUT;
	}
	
	/* Ԥ֤ */
	 mknl_wai_tsk(&tcb_ram->mtcb, TTW_SLP);
	
	/* ॢԤɲ */
	if ( tmout != TMO_FEVR )
	{
		mknl_add_tmout(&tcb_ram->mtcb, (RELTIM)tmout);
	}
	
	ercd = (ER)mknl_exe_dsp();	/* ǥѥåμ¹ */
	mknl_exe_tex();				/* 㳰μ¹ */
	
	mknl_unl_sys();	/* ƥΥå */
	
	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
