package coboled.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.SWT;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class CobolViewerDecorationSupport extends SourceViewerDecorationSupport {

	private ISourceViewer sourceViewer = null;

	private ISharedTextColors fSharedTextColors = null;

	private List<MarginPainter> fMarginPainters = new ArrayList<MarginPainter>();

	private List<Integer> rulerColumns = Arrays.asList(6, 7, 11, 72, 80);

	public CobolViewerDecorationSupport(ISourceViewer sourceViewer,
			IOverviewRuler overviewRuler, IAnnotationAccess annotationAccess,
			ISharedTextColors sharedTextColors) {
		super(sourceViewer, overviewRuler, annotationAccess, sharedTextColors);
		this.sourceViewer = sourceViewer;
		this.fSharedTextColors = sharedTextColors;
	}

	@Override
	public void dispose() {
		super.dispose();
		fSharedTextColors = null;
		clearMargins();
	}

	@Override
	public void install(IPreferenceStore store) {
		super.install(store);
		showMargins();
	}

	private void showMargins() {
		if (fMarginPainters != null && fMarginPainters.size() != 0) {
			return;
		}
		if (sourceViewer instanceof ITextViewerExtension2) {
			Iterator<Integer> iter = rulerColumns.iterator();
			while (iter.hasNext()) {
				MarginPainter marginPainter = new MarginPainter(sourceViewer);
				marginPainter = new MarginPainter(sourceViewer);
				marginPainter.setMarginRulerColor(fSharedTextColors.getColor(ICobolColorConstants.MARGIN));
				marginPainter.setMarginRulerColumn(iter.next());
				marginPainter.setMarginRulerWidth(1);
				marginPainter.setMarginRulerStyle(SWT.LINE_SOLID);
				ITextViewerExtension2 extension= (ITextViewerExtension2) sourceViewer;
				extension.addPainter(marginPainter);
				fMarginPainters.add(marginPainter);
			}
		}
	}

	private void clearMargins() {
		if (fMarginPainters != null && fMarginPainters.size() != 0) {
			fMarginPainters.clear();
			fMarginPainters = new ArrayList<MarginPainter>();
		}
	}
}
