﻿using System;
using System.Text;
using System.IO;
using System.IO.MemoryMappedFiles;
using System.Collections.Generic;

namespace CompleteEraser
{
    class SharedInfo : IEnumerable<string>, IDisposable
    {
        MemoryMappedFile mmf;
        public SharedInfo()
        {
            mmf = MemoryMappedFile.OpenExisting("CompleteEraser.MemMap");
        }

        public IEnumerator<string> GetEnumerator()
        {
            MemoryMappedViewStream mms = mmf.CreateViewStream();
            StreamReader sr = new StreamReader(mms, Encoding.Unicode);
            try
            {
                while (sr.EndOfStream == false)
                {
                    string s = sr.ReadLine();
                    if(s != string.Empty && s[0] != '\0')
                        yield return s;
                }
            }
            finally
            {
                sr.Close();
                mms.Close();
            }
        }

        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            throw new NotImplementedException();
        }

        public void Dispose()
        {
            GC.SuppressFinalize(this);
            mmf.Dispose();
        }
    }
}
