﻿using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.IO;
using System.Threading;
using System.Threading.Tasks;

namespace CompleteEraser
{
    class BreakRecyleBin : IOperation
    {
        [DllImport("shell32.dll")]
        static extern int SHEmptyRecycleBin(IntPtr hWnd, string pszRootPath,uint dwFlags);
        //     No dialog box confirming the deletion of the objects will be displayed.
        const uint SHERB_NOCONFIRMATION = 0x00000001;
        //     No dialog box indicating the progress will be displayed.
        const uint SHERB_NOPROGRESSUI = 0x00000002;
        //     No sound will be played when the operation is complete.
        const uint SHERB_NOSOUND = 0x00000004;        

        public event ProgressingEventHandler Progressing;
        public event ProgressedEventHandler Progressed;
        public event EventHandler Complete;

        public async void ExecuteAsync(IEnumerable<string> files,CancellationToken cancelToken)
        {
            foreach (string file in files)
            {
                Progressing(this, new ProgressingEventArgs(file));

                try
                {
                    await Task.Factory.StartNew(() =>
                    {
                        FileBreaker.BreakFileOrFolder(file);
                    }, cancelToken);
                }
                catch (OperationCanceledException)
                {
                    return;
                }
                catch (IOException)
                {
                    //ゴミ箱の中にフォルダーがあるとIOErrorがでるので握りつぶす
                }

                Progressed(this, new ProgressedEventArgs(file, null));
            }

            Progressing(this, new ProgressingEventArgs(null));
            SHEmptyRecycleBin(IntPtr.Zero, "", SHERB_NOCONFIRMATION | SHERB_NOPROGRESSUI);

            this.Complete(this, null);
        }
    }
}
