package jp.cssj.cti2.examples;

import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;

import jp.cssj.cti2.CTIDriverManager;
import jp.cssj.cti2.CTISession;
import jp.cssj.cti2.helpers.CTISessionHelper;
import jp.cssj.resolver.helpers.MetaSourceImpl;

/**
 * クライアントから送ったデータを変換します。
 */
public class Continuous {
	/** 接続先。 */
	private static final URI SERVER_URI = URI.create("ctip://127.0.0.1:8099/");

	/** ユーザー。 */
	private static final String USER = "user";

	/** パスワード。 */
	private static final String PASSWORD = "kappa";

	public static void main(String[] args) throws Exception {
		// 接続する
		CTISession session = CTIDriverManager.getSession(SERVER_URI, USER,
				PASSWORD);
		try {
			// test.pdfに結果を出力する
			File file = new File("test.pdf");
			CTISessionHelper.setResultFile(session, file);
			session.setContinuous(true);

			// リソースの送信
			{
				PrintWriter out = new PrintWriter(new OutputStreamWriter(
						session.resource(new MetaSourceImpl(URI
								.create("style.css"), "text/html")), "UTF-8"));
				try {
					// CSSを出力
					out.println("p {color: Red;}");
				} finally {
					out.close();
				}
			}

			// http://www.cssj.jp/以下にあるリソースへのアクセスを許可する
			session.property("input.include", "http://print.cssj.jp/**");

			// ウェブページを変換
			session.transcode(URI.create("http://print.cssj.jp/"));

			session.join();
		} finally {
			// セッションを閉じる(忘れやすいので注意!)
			session.close();
		}
	}
}