package jp.cssj.cti2.progress;

/**
 * サーバ側でのメインドキュメントの処理状況を受け取ります。
 * 
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: ProgressListener.java 457 2010-05-20 02:26:26Z miyabe $
 */
public interface ProgressListener {
	/**
	 * <p>
	 * サーバ側で見積もられたメインドキュメントの大きさを受け取ります。
	 * </p>
	 * <p>
	 * このメソッドは呼ばれないことがあり、不正確な値が渡される可能性もあります。
	 * </p>
	 * 
	 * @param sourceLength
	 *            メインドキュメントのバイト数。
	 */
	public void sourceLength(long sourceLength);

	/**
	 * 処理されたメインドキュメントのバイト数を受け取ります。
	 * 
	 * @param serverRead
	 *            読み込み済みバイト数。
	 */
	public void progress(long serverRead);
}