package jp.cssj.cti2.results;

import java.io.File;

import jp.cssj.resolver.MetaSource;
import jp.cssj.rsr.RandomBuilder;
import jp.cssj.rsr.impl.FileRandomBuilder;

/**
 * ディレクトリに複数の結果を出力するResultsです。
 * 
 * @author <a href="miyabe at gnn.co.jp">MIYABE Tatsuhiko</a>
 * @version $Id: SingleResult.java 312 2009-07-30 08:37:37Z miyabe $
 */
public class DirectoryResults implements Results {
	protected final File dir;
	protected final String prefix, suffix;
	protected int counter = 0;

	/**
	 * 出力先ディレクトリとファイル名の前後を指定してオブジェクトを構築します。
	 * <p>
	 * ファイルはdirに出力され、ファイル名は prefix, 1から始まる通し番号, suffixを連結したものとなります。
	 * </p>
	 * 
	 * @param dir
	 *            出力先ディレクトリです。
	 * @param prefix
	 *            ファイル名の前に付ける文字列です。
	 * @param suffix
	 *            ファイル名の後に付ける文字列です。
	 */
	public DirectoryResults(File dir, String prefix, String suffix) {
		this.dir = dir;
		this.prefix = prefix;
		this.suffix = suffix;
	}

	public boolean hasNext() {
		return true;
	}

	public RandomBuilder nextBuilder(MetaSource metaSource) {
		++this.counter;
		File file = new File(this.dir, this.prefix + this.counter + this.suffix);
		return new FileRandomBuilder(file);
	}

	public void end() {
		// NOP
	}
}
