package jp.cssj.cr.epub;

import java.io.IOException;
import java.io.InputStream;

import jp.cssj.print.epub.ArchiveFile;
import android.content.res.AssetManager;

public class AssetArchiveFile implements ArchiveFile {
	private AssetManager assets;
	private String base;

	public AssetArchiveFile(AssetManager assets, String base) {
		this.assets = assets;
		this.base = base;
	}

	public boolean exists(String path) {
		try {
			return this.assets.openFd(path).getLength() > 0;
		} catch (IOException e) {
			return false;
		}
	}

	public InputStream getInputStream(String path) throws IOException {
		return this.assets.open(this.base + "/" + path);
	}

}
