package jp.cssj.homare.impl.css.part;

import jp.cssj.cr.compat.XPath;
import jp.cssj.cr.compat.XRectF;
import jp.cssj.homare.css.util.ColorValueUtils;
import jp.cssj.sakae.gc.GC;
import jp.cssj.sakae.gc.GraphicsException;
import jp.cssj.sakae.gc.image.Image;

/**
 * @author <a href="mailto:tatsuhiko at miya.be">MIYABE Tatsuhiko </a>
 * @version $Id: CircleImage.java,v 1.2 2007-05-06 04:24:06 miyabe Exp $
 */
public class SelectImage implements Image {
	private final boolean disabled;
	private final double height;

	public SelectImage(boolean disabled, double height) {
		this.disabled = disabled;
		this.height = height;
	}

	public double getWidth() {
		return 16.0;
	}

	public double getHeight() {
		return this.height;
	}

	public String getAltString() {
		return "○";
	}

	public void drawTo(GC gc) throws GraphicsException {
		gc.begin();

		gc.setLineWidth(1.0);
		gc.setLinePattern(GC.STROKE_SOLID);
		XRectF frame = new XRectF(0, 0, 16, this.height);
		XRectF upFrame = new XRectF(0, 0, 16, 16);
		XPath up, upShadow;
		{
			XPath path = new XPath();
			path.moveTo(8, 4);
			path.lineTo(3, 10);
			path.lineTo(13, 10);
			up = path;
			path = new XPath();
			path.moveTo(16, 0);
			path.lineTo(16, 16);
			path.lineTo(0, 16);
			upShadow = path;
		}
		XRectF downFrame = new XRectF(0, this.height - 16, 16, 16);
		XPath down, downShadow;
		{
			XPath path = new XPath();
			path.moveTo(8, (float) (this.height - 4));
			path.lineTo(3, (float) (this.height - 10));
			path.lineTo(13, (float) (this.height - 10));
			down = path;
			path = new XPath();
			path.moveTo(16, (float) (this.height - 16));
			path.lineTo(16, (float) this.height);
			path.lineTo(0, (float) this.height);
			downShadow = path;
		}

		gc.setFillPaint(ColorValueUtils.LIGHTGRAY);
		gc.fill(frame);

		gc.fill(upFrame);
		gc.setFillPaint(this.disabled ? ColorValueUtils.DIMGRAY
				: ColorValueUtils.BLACK);
		gc.fill(up);
		gc.draw(upShadow);

		gc.setFillPaint(ColorValueUtils.LIGHTGRAY);
		gc.fill(downFrame);
		gc.setFillPaint(this.disabled ? ColorValueUtils.DIMGRAY
				: ColorValueUtils.BLACK);
		gc.fill(down);
		gc.draw(downShadow);

		gc.end();
	}
}
