package jp.cssj.homare.impl.css.part;

import jp.cssj.cr.compat.XRectF;
import jp.cssj.sakae.gc.GC;
import jp.cssj.sakae.gc.GraphicsException;
import jp.cssj.sakae.gc.font.FontStyle;
import jp.cssj.sakae.gc.image.Image;
import jp.cssj.sakae.gc.paint.Color;

/**
 * @author <a href="mailto:tatsuhiko at miya.be">MIYABE Tatsuhiko </a>
 * @version $Id: SquareImage.java,v 1.2 2007-05-06 04:24:06 miyabe Exp $
 */
public class SquareImage implements Image {
	protected final double size;

	protected final Color color;

	public SquareImage(FontStyle fontStyle, Color color) {
		this.size = fontStyle.getSize();
		this.color = color;
	}

	public double getWidth() {
		return this.size;
	}

	public double getHeight() {
		return this.size;
	}

	public String getAltString() {
		return "■";
	}

	public void drawTo(GC gc) throws GraphicsException {
		gc.begin();

		gc.setFillPaint(this.color);

		double d = this.size * 0.35;
		gc.fill(new XRectF(this.size / 2.0 - d / 2.0, this.size * 0.2
				+ this.size / 2.0 - d / 2.0, d, d));
		gc.end();
	}
}
