package jp.cssj.cr.epub;

import java.io.File;
import java.util.zip.ZipFile;

import jp.cssj.android.R;
import jp.cssj.print.epub.Container;
import jp.cssj.print.epub.Contents;
import jp.cssj.print.epub.EPubFile;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class BookshelfItemAdapter extends ArrayAdapter<File> {
	public BookshelfItemAdapter(Context context, int textViewResourceId) {
		super(context, textViewResourceId);
	}

	public View getView(int position, View view, ViewGroup parent) {
		LayoutInflater inflater = (LayoutInflater) this.getContext()
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		if (view == null) {
			view = inflater.inflate(R.layout.bookshelf_item, null);
		}
		TextView title = (TextView) view.findViewById(R.id.bookshelfTitle);
		TextView filename = (TextView) view
				.findViewById(R.id.bookshelfFilename);
		TextView size = (TextView) view.findViewById(R.id.bookshelfSize);

		File file = this.getItem(position);
		try {
			if (file.isDirectory()) {
				title.setText(file.getName());
				filename.setText("");
				size.setText("");
			} else {
				ZipFile zip = new ZipFile(file);
				try {
					EPubFile epub = new EPubFile(zip);
					Container cr = epub.readContainer();
					Contents cs = epub.readContents(cr.rootfiles[0]);
					title.setText(cs.title);
					filename.setText(file.getName());
					size.setText(" - " + (int) (file.length() / 1000) + "kb");
				} finally {
					zip.close();
				}
			}
		} catch (Exception e) {
			Log.e(this.getClass().getName(), "EPUB error.", e);
		}
		return view;
	}
}
