package jp.cssj.resolver.http;

import java.io.IOException;
import java.net.URI;

import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceResolver;

import org.apache.http.client.HttpClient;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

/**
 * HttpClientを利用してデータを所得するSourceResolverです。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: HttpSourceResolver.java 590 2011-08-28 04:43:07Z miyabe $
 */
public class HttpSourceResolver implements SourceResolver {
	protected HttpClient createHttpClient() {
		final SchemeRegistry schreg = new SchemeRegistry();
		schreg.register(new Scheme("http", PlainSocketFactory
				.getSocketFactory(), 80));
		schreg.register(new Scheme("https",
				SSLSocketFactory.getSocketFactory(), 443));

		final HttpParams params = new BasicHttpParams();

		final ThreadSafeClientConnManager connManager = new ThreadSafeClientConnManager(
				params, schreg);
		final HttpClient client = new DefaultHttpClient(connManager, params);
		return client;
	}

	public Source resolve(final URI uri) throws IOException {
		final HttpClient client = this.createHttpClient();
		final HttpSource source = new HttpSource(uri, client);
		return source;
	}

	public void release(final Source source) {
		((HttpSource) source).close();
	}
}