/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ncx;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ncx.NCXHandler;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.io.IOException;

public class NCXChecker
implements ContentChecker {
    OCFPackage ocf;
    Report report;
    String path;
    XRefChecker xrefChecker;
    static XMLValidator ncxValidator = new XMLValidator("schema/20/rng/ncx.rng");
    static XMLValidator ncxSchematronValidator = new XMLValidator("schema/20/sch/ncx.sch");

    public NCXChecker(OCFPackage ocf, Report report, String path, XRefChecker xrefChecker) {
        this.ocf = ocf;
        this.report = report;
        this.path = path;
        this.xrefChecker = xrefChecker;
    }

    @Override
    public void runChecks() {
        if (!this.ocf.hasEntry(this.path)) {
            this.report.error(null, 0, 0, "NCX file " + this.path + " is missing");
        } else if (!this.ocf.canDecrypt(this.path)) {
            this.report.error(null, 0, 0, "NCX file " + this.path + " cannot be decrypted");
        } else {
            XMLParser ncxParser = null;
            try {
                ncxParser = new XMLParser(this.ocf.getInputStream(this.path), this.path, "", this.report);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ncxParser.addValidator(ncxValidator);
            NCXHandler ncxHandler = new NCXHandler(ncxParser, this.path, this.xrefChecker);
            ncxParser.addXMLHandler(ncxHandler);
            ncxParser.process();
            try {
                ncxParser = new XMLParser(this.ocf.getInputStream(this.path), this.path, "application/x-dtbncx+xml", this.report);
                ncxParser.addValidator(ncxSchematronValidator);
                ncxHandler = new NCXHandler(ncxParser, this.path, this.xrefChecker);
                ncxParser.process();
            }
            catch (Throwable t) {
                this.report.error(this.path, -1, 0, "Failed performing NCX Schematron tests: " + t.getMessage());
            }
        }
    }
}

