/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ops;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;

public class OPSHandler
implements XMLHandler {
    String path;
    XRefChecker xrefChecker;
    static HashSet<String> regURISchemes = OPSHandler.fillRegURISchemes();
    XMLParser parser;
    Report report;

    private static HashSet<String> fillRegURISchemes() {
        try {
            HashSet<String> set = new HashSet<String>();
            InputStream schemaStream = OPSHandler.class.getResourceAsStream("registeredSchemas.txt");
            BufferedReader schemaReader = new BufferedReader(new InputStreamReader(schemaStream));
            String schema = schemaReader.readLine();
            while (schema != null) {
                set.add(schema);
                schema = schemaReader.readLine();
            }
            schemaReader.close();
            schemaStream.close();
            return set;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public OPSHandler(String path, XRefChecker xrefChecker, XMLParser parser, Report report) {
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.report = report;
        this.parser = parser;
    }

    private void checkPaint(XMLElement e, String attr) {
        String paint = e.getAttribute(attr);
        if (this.xrefChecker != null && paint != null && paint.startsWith("url(") && paint.endsWith(")")) {
            String href = paint.substring(4, paint.length() - 1);
            href = PathUtil.resolveRelativeReference(this.path, href);
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, 16);
        }
    }

    private void checkClip(XMLElement e, String attr) {
    }

    private void checkImage(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (this.xrefChecker != null && href != null) {
            href = PathUtil.resolveRelativeReference(this.path, href);
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, 2);
        }
    }

    private void checkObject(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (this.xrefChecker != null && href != null) {
            href = PathUtil.resolveRelativeReference(this.path, href);
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, 3);
        }
    }

    private void checkLink(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        String rel = e.getAttributeNS(attrNS, "rel");
        if (this.xrefChecker != null && href != null && rel != null && rel.indexOf("stylesheet") >= 0) {
            href = PathUtil.resolveRelativeReference(this.path, href);
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, 4);
        }
    }

    private void checkSymbol(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (this.xrefChecker != null && href != null) {
            href = PathUtil.resolveRelativeReference(this.path, href);
            this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, 18);
        }
    }

    private void checkHRef(XMLElement e, String attrNS, String attr) {
        String href = e.getAttributeNS(attrNS, attr);
        if (href != null) {
            if (OPSHandler.isRegisteredSchemaType(href)) {
                return;
            }
            if (href.indexOf(58) > 0) {
                this.report.warning(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "use of non-registered URI schema type in href: " + href);
                return;
            }
            try {
                href = PathUtil.resolveRelativeReference(this.path, href);
            }
            catch (IllegalArgumentException err) {
                this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), err.getMessage());
                return;
            }
            if (this.xrefChecker != null) {
                this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, 1);
            }
        }
    }

    public static boolean isRegisteredSchemaType(String href) {
        int colonIndex = href.indexOf(58);
        if (colonIndex < 0) {
            return false;
        }
        if (regURISchemes.contains(href.substring(0, colonIndex + 1))) {
            return true;
        }
        if (href.length() > colonIndex + 2) {
            return href.substring(colonIndex + 1, colonIndex + 3).equals("//") && regURISchemes.contains(href.substring(0, colonIndex + 3));
        }
        return false;
    }

    @Override
    public void startElement() {
        XMLElement e = this.parser.getCurrentElement();
        String id = e.getAttribute("id");
        String ns = e.getNamespace();
        String name = e.getName();
        int resourceType = 0;
        if (ns != null) {
            if (ns.equals("http://www.w3.org/2000/svg")) {
                if (name.equals("parser.getLineNumber()arGradient") || name.equals("radialGradient") || name.equals("pattern")) {
                    resourceType = 16;
                } else if (name.equals("clipPath")) {
                    resourceType = 17;
                } else if (name.equals("symbol")) {
                    resourceType = 18;
                } else if (name.equals("a")) {
                    this.checkHRef(e, "http://www.w3.org/1999/xlink", "href");
                } else if (name.equals("use")) {
                    this.checkSymbol(e, "http://www.w3.org/1999/xlink", "href");
                } else if (name.equals("image")) {
                    this.checkImage(e, "http://www.w3.org/1999/xlink", "href");
                }
                this.checkPaint(e, "fill");
                this.checkPaint(e, "stroke");
                this.checkClip(e, "clip");
            } else if (ns.equals("http://www.w3.org/1999/xhtml")) {
                if (name.equals("a")) {
                    this.checkHRef(e, null, "href");
                } else if (name.equals("img")) {
                    this.checkImage(e, null, "src");
                } else if (name.equals("object")) {
                    this.checkObject(e, null, "data");
                } else if (name.equals("link")) {
                    this.checkLink(e, null, "href");
                }
                resourceType = 1;
            }
        }
        if (this.xrefChecker != null && id != null) {
            this.xrefChecker.registerAnchor(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), id, resourceType);
        }
    }

    @Override
    public void endElement() {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void characters(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }
}

