/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.overlay;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.overlay.OverlayHandler;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.io.IOException;

public class OverlayChecker
implements ContentChecker,
DocumentValidator {
    OCFPackage ocf;
    Report report;
    String path;
    XRefChecker xrefChecker = null;
    GenericResourceProvider resourceProvider;
    private OverlayHandler overlayHandler = null;
    static XMLValidator mediaOverlayValidator_30_RNC = new XMLValidator("schema/30/media-overlay-30.rnc");
    static XMLValidator mediaOverlayValidator_30_SCH = new XMLValidator("schema/30/media-overlay-30-PREP.sch");

    public OverlayChecker(OCFPackage ocf, Report report, String path, XRefChecker xrefChecker) {
        this.ocf = ocf;
        this.resourceProvider = ocf;
        this.report = report;
        this.path = path;
        this.xrefChecker = xrefChecker;
    }

    public OverlayChecker(String path, GenericResourceProvider resourceProvider, Report report) {
        this.resourceProvider = resourceProvider;
        this.report = report;
        this.path = path;
    }

    @Override
    public void runChecks() {
        if (!this.ocf.hasEntry(this.path)) {
            this.report.error(null, 0, 0, "File " + this.path + " is missing");
        } else if (!this.ocf.canDecrypt(this.path)) {
            this.report.error(null, 0, 0, "File " + this.path + " cannot be decrypted");
        } else {
            this.validate();
        }
    }

    @Override
    public boolean validate() {
        int errorsSoFar = this.report.getErrorCount();
        int warningsSoFar = this.report.getWarningCount();
        try {
            XMLParser overlayParser = new XMLParser(this.resourceProvider.getInputStream(this.path), this.path, "application/smil+xml", this.report);
            this.overlayHandler = new OverlayHandler(this.path, this.xrefChecker, overlayParser, this.report);
            overlayParser.addValidator(mediaOverlayValidator_30_RNC);
            overlayParser.addValidator(mediaOverlayValidator_30_SCH);
            overlayParser.addXMLHandler(this.overlayHandler);
            overlayParser.process();
        }
        catch (IOException e) {
            this.report.error(this.path, -1, -1, String.format(Messages.MISSING_FILE, this.path));
        }
        return errorsSoFar == this.report.getErrorCount() && warningsSoFar == this.report.getWarningCount();
    }
}

