/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.api.Report;
import java.util.HashSet;

public class HandlerUtil {
    public static void processPrefixes(String prefix, HashSet<String> prefixSet, Report report, String path, int line, int column) {
        if (prefix == null) {
            return;
        }
        prefix = prefix.replaceAll("[\\s]+", " ");
        String[] prefixArray = prefix.split(" ");
        for (int i = 0; i < prefixArray.length; ++i) {
            boolean validPrefix = true;
            if (!prefixArray[i].endsWith(":")) {
                report.error(path, line, column, "Invalid prefix " + prefixArray[i]);
                validPrefix = false;
            }
            if (i + 1 >= prefixArray.length) {
                report.error(path, line, column, "URL for prefix " + prefixArray[i] + "doesn't exist");
                return;
            }
            if (!prefixArray[++i].startsWith("http://")) {
                report.error(path, line, column, "URL expected instead of " + prefixArray[i - 1]);
                continue;
            }
            if (!validPrefix) continue;
            if (!prefixSet.contains(prefixArray[i - 1].substring(0, prefixArray[i - 1].length() - 1))) {
                prefixSet.add(prefixArray[i - 1].substring(0, prefixArray[i - 1].length() - 1));
                continue;
            }
            report.error(path, line, column, "Redeclaration of " + prefixArray[i - 1].substring(0, prefixArray[i - 1].length() - 1) + " prefix! Make sure it is not a reserved prefix!");
        }
    }
}

