package yukihane.inqubus.config;

import java.io.File;
import saccubus.worker.profile.CommentProfile;

/**
 * コンフィグに設定された値を基にしたCommentProfile実装.
 * @author yuki
 */
public class ConfigCommentProfile implements CommentProfile {

    private final int lengthRelatedCommentSize;
    private final int perMinCommentSize;
    private final boolean disablePerMinComment;
    private final long backLogPoint;
    private final boolean download;
    private final boolean ownerCommentOnly;
    private final File dir;
    private final String fileName;

    public ConfigCommentProfile() {
        final Config p = Config.INSTANCE;
        this.lengthRelatedCommentSize = (p.getCommentSizeAutosize()) ? -1 : Integer.parseInt(p.getCommentSizeManual());
        this.perMinCommentSize = (p.getCommentMinSizeAutosize()) ? -1 : Integer.parseInt(p.getCommentMinSizeManual());
        this.disablePerMinComment = p.getCommentMinDisabled();
        this.backLogPoint = -1L;
        this.download = !p.getCommentUseLocal();
        this.ownerCommentOnly = p.getCommentOwnerOnly();
        this.dir = new File(p.getCommentDir());
        this.fileName = p.getCommentFileNamePattern();
    }

    @Override
    public int getLengthRelatedCommentSize() {
        return lengthRelatedCommentSize;
    }

    @Override
    public boolean isDisablePerMinComment() {
        return disablePerMinComment;
    }

    @Override
    public int getPerMinCommentSize() {
        return perMinCommentSize;
    }

    @Override
    public long getBackLogPoint() {
        return backLogPoint;
    }

    @Override
    public boolean isOwnerCommentOnly() {
        return ownerCommentOnly;
    }

    @Override
    public boolean isDownload() {
        return download;
    }

    @Override
    public File getDir() {
        return dir;
    }

    @Override
    public String getFileName() {
        return fileName;
    }

    @Override
    public File getLocalFile() {
        return getDir();
    }
}
