package yukihane.inqubus.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle.ComponentPlacement;
import org.apache.commons.lang.StringUtils;

/**
 *
 * @author yuki
 */
class NgRegisterPanel extends JPanel {
    private static final long serialVersionUID = 1L;
    private final DefaultListModel<String> mdlNgWord = new DefaultListModel<>();
    private final JList<String> lstNgWord = new JList<>();
    private final JTextField fldNgWord = new JTextField();
    private final JButton btnNgWordAdd = new JButton("追加");
    private final JButton btnNgWordDel = new JButton("削除");


    void init(List<String> ngWords) {
        mdlNgWord.clear();
        for (String s : ngWords) {
            mdlNgWord.addElement(s);
        }
    }

    List<String> getAllElements() {
        List<String> res = new ArrayList<>(mdlNgWord.getSize());
        for (int i = 0; i < mdlNgWord.getSize(); i++) {
            res.add(mdlNgWord.get(i));
        }
        return res;
    }

    NgRegisterPanel() {
        final JScrollPane scrNgWord = new JScrollPane();
        lstNgWord.setModel(mdlNgWord);
        scrNgWord.setViewportView(lstNgWord);


        btnNgWordDel.addActionListener(new DelActionListener());
        final AddActionListener aal = new AddActionListener();
        btnNgWordAdd.addActionListener(aal);
        fldNgWord.addActionListener(aal);

        final GroupLayout gl = new GroupLayout(this);
        setLayout(gl);
        gl.setHorizontalGroup(
            gl.createParallelGroup(Alignment.LEADING)
            .addGroup(gl.createSequentialGroup()
                .addContainerGap()
                .addGroup(gl.createParallelGroup(Alignment.LEADING)
                    .addComponent(scrNgWord, GroupLayout.DEFAULT_SIZE, 395, Short.MAX_VALUE)
                    .addGroup(gl.createSequentialGroup()
                        .addComponent(fldNgWord, GroupLayout.DEFAULT_SIZE, 256, Short.MAX_VALUE)
                        .addPreferredGap(ComponentPlacement.RELATED)
                        .addComponent(btnNgWordAdd)
                        .addGap(50)
                        .addComponent(btnNgWordDel)))
                .addContainerGap())
        );
        gl.setVerticalGroup(
            gl.createParallelGroup(Alignment.LEADING)
            .addGroup(gl.createSequentialGroup()
                .addContainerGap()
                .addComponent(scrNgWord, GroupLayout.PREFERRED_SIZE, 100, Short.MAX_VALUE)
                .addPreferredGap(ComponentPlacement.RELATED)
                .addGroup(gl.createParallelGroup(Alignment.BASELINE)
                    .addComponent(fldNgWord, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnNgWordDel)
                    .addComponent(btnNgWordAdd))
                .addContainerGap())
        );

    }

    private class AddActionListener implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            final String w = fldNgWord.getText();
            if (StringUtils.isBlank(w)) {
                return;
            }
            mdlNgWord.addElement(w);
            lstNgWord.ensureIndexIsVisible(mdlNgWord.getSize() - 1);
            fldNgWord.setText("");
        }
    }

    private class DelActionListener implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            final int idx = lstNgWord.getSelectedIndex();
            if(idx < 0) {
                return;
            }
            mdlNgWord.remove(idx);
        }
    }
}
