package saccubus.worker.impl.download;

import org.apache.commons.lang.builder.ToStringBuilder;
import saccubus.worker.impl.MessageReportable;
import saccubus.worker.impl.PercentageReportable;

/**
 *
 * @author yuki
 */
public class DownloadProgress implements PercentageReportable, MessageReportable {

    private final DownloadStatus status;
    private final double percentage;
    private final String message;

    DownloadProgress(DownloadStatus status, double percentage, String message) {
        this.status = status;
        this.percentage = percentage;
        this.message = message;
    }

    public DownloadStatus getStatus() {
        return status;
    }

    public String getMessage() {
        return message;
    }

    @Override
    public double getPercentage() {
        return percentage;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
