package saccubus.worker.profile;

/**
 * 変換対象となるコメントファイル情報を保持するためのプロファイルです.
 * @author yuki
 */
public interface CommentProfile extends Inputable {

    /**
     * @return {@link #isDownload()}がtrueの場合に
     * 取得する「再生時間に応じたコメント」数. 負値の場合は再生時間に応じた
     * 既定数を取得します.
     * {@link #isDownload()}がfalseの場合未定義.
     */
    int getLengthRelatedCommentSize();

    /**
     * @return {@link #isDownload()}がtrueの場合に,
     * 投稿者コメントのみ取得する場合はtrue. 通常コメントも取得する場合はfalse.
     * {@link #isDownload()}がfalseの場合未定義.
     */
    boolean isOwnerCommentOnly();

    /**
     * @return {@link #isDownload()}がtrueの場合に,
     * 昔の仕様でコメントダウンロードを行う場合はtrue. 現在の仕様で行う場合はfalse.
     * {@link #isDownload()}がfalseの場合未定義.
     */
    boolean isDisablePerMinComment();

    /**
     * @return {@link #isDownload()}がtrue, かつ
     * {@link #isDisablePerMinComment()}がfalseの場合に
     * 取得する「1分当たりコメント」数. 負値の場合は再生時間に応じた
     * 既定数を取得します.
     * {@link #isDownload()}がfalse, または
     * {@link #isDisablePerMinComment()}がtrueの場合未定義.
     */
    int getPerMinCommentSize();

    /**
     * @return {@link #isDownload()}がtrueの場合に,過去ログを取得する時点.
     * 1970/1/1 00:00:00 GMT からの経過秒数(ミリ秒ではない).
     * 負値の場合は過去ログ取得ではない.
     * {@link #isDownload()}がfalseの場合未定義.
     */
    long getBackLogPoint();
}
