package yukihane.inqubus.config;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import saccubus.worker.profile.ProxyProfile;

/**
 * コンフィグに設定された値を基にしたProxyProfile実装.
 * @author yuki
 */
public class ConfigProxyProfile implements ProxyProfile {

    private final boolean use;
    private final String host;
    private final int port;

    public ConfigProxyProfile() {
        final Config p = Config.INSTANCE;
        this.use = p.getProxyUse();
        this.host = p.getProxyHost();
        final String pp = p.getProxyPort();
        this.port = StringUtils.isBlank(pp) ? -1 : Integer.parseInt(pp);
    }

    @Override
    public boolean use() {
        return this.use;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
