package yukihane.inqubus.cookie;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

/**
 * WindowsのFirefox(4以降) cookie ディレクトリを決め打ちして扱います.
 * @author orz (saccubus)
 * @author yuki
 */
class CookieWinFirefox extends Cookie {

    /**
     * Firefox4以降から user_session を取得。
     * @return　ユーザセッション文字列.
     * @throws IOException 取得失敗.
     */
    @Override
    protected String getNicoUserSession() throws IOException {
        final String appData = System.getenv("APPDATA");
        if (StringUtils.isNotEmpty(appData)) {
            final File dir = new File(appData + "/Mozilla/Firefox/Profiles/");
            final File[] userLists = dir.listFiles();
            for (File profileDir : userLists) {
                final File sqliteFile = new File(profileDir, "cookies.sqlite");
                if (sqliteFile.isFile()) {
                    final String user_session = getUserSession("US-ASCII", sqliteFile);
                    if (StringUtils.isNotEmpty(user_session)) {
                        return user_session;
                    }
                    // else continue
                }
            }
        }
        return "";
    }
}
