package yukihane.inqubus.cookie;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

/**
 * WindowsのOpera cookie ディレクトリを決め打ちして扱います.
 * @author rankingloid (nicorank)
 * @author hazychill (nicorank)
 * @author orz (saccubus)
 * @author yuki
 */
class CookieWinOpera extends Cookie {

    /**
     * Opera から user_session を取得。
     * @return ユーザセッション文字列.
     * @throws IOException 取得失敗.
     */
    @Override
    protected String getNicoUserSession() throws IOException {
        final String appData = System.getenv("APPDATA");

        if (StringUtils.isNotEmpty(appData)) {
            final File cookieFile = new File(appData + "/Opera/Opera/cookies4.dat");
            return getUserSession("UTF-8", cookieFile);
        }

        return "";
    }
}
