package yukihane.inqubus.cookie;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

/**
 * Windows ChromiumのCookieディレクトリを決め打ちして扱います.
 * @author orz (saccubus)
 * @author yuki
 */
class CookieWinChromium extends Cookie {

    private static final String CHROMIUM_PATH = "/Chromium/User Data/Default/Cookies";

    @Override
    protected String getNicoUserSession() throws IOException {
        final String localAppData = System.getenv("LOCALAPPDATA");
        if (StringUtils.isNotEmpty(localAppData)) {
            // Win7 32bit
            final File cookieFile = new File(localAppData + CHROMIUM_PATH);
            if (cookieFile.isFile()) {
                return getUserSession("UTF-8", cookieFile);
            }
        }

        final String userProfile = System.getenv("USERPROFILE");
        if (StringUtils.isNotEmpty(userProfile)) {
            // XP 32bit
            final File cookieFile = new File(userProfile + "/Local Settings/Application Data" + CHROMIUM_PATH);
            if (cookieFile.isFile()) {
                return getUserSession("UTF-8", cookieFile);
            }
        }

        return "";

    }
}
