package yukihane.inqubus.saccubus.prompt;

import java.io.IOException;
import saccubus.worker.profile.OutputProfile;
import yukihane.inqubus.config.ConfigConvertProfile;
import yukihane.inqubus.config.ConfigOutputProfile;

/**
 * さきゅばすのコマンドプロンプト仕様にあわせるためのConvertProfile実装
 * @author yuki
 */
class ConvertProfileImpl extends ConfigConvertProfile {

    private final OutputProfile outputProfile;

    ConvertProfileImpl(final String videoId, final String title) throws IOException {
        outputProfile = new ConfigOutputProfile() {

            @Override
            public String getVideoId() {
                return videoId;
            }

            @Override
            public String getTitile() {
                return title;
            }
        };
    }

    @Override
    public OutputProfile getOutputProfile() {
        return outputProfile;
    }
}
