/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package yukihane.jnicoapi;

import java.io.IOException;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.params.BasicHttpParams;
import static org.junit.Assert.*;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import static org.powermock.api.mockito.PowerMockito.*;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import yukihane.jnicoapi.entity.NicoContent;

/**
 *
 * @author yuki
 */
@RunWith(PowerMockRunner.class)
@PrepareForTest(DefaultHttpClient.class)
public class NicoHttpClientRssTest {

//    private HttpResponse prepareResponse(int expectedResponseStatus,
//            String expectedResponseBody) {
//        HttpResponse response = new BasicHttpResponse(new BasicStatusLine(
//                new ProtocolVersion("HTTP", 1, 1), expectedResponseStatus, ""));
//        response.setStatusCode(expectedResponseStatus);
//        try {
//            response.setEntity(new StringEntity(expectedResponseBody));
//        } catch (UnsupportedEncodingException e) {
//            throw new IllegalArgumentException(e);
//        }
//        return response;
//    }
    private HttpResponse prepareResponse(String filename) {
        final HttpResponse response = new BasicHttpResponse(
                new BasicStatusLine(new ProtocolVersion("http", 1, 1), 200, ""));
        response.setEntity(new InputStreamEntity(getClass().getResourceAsStream(filename), 1));
        return response;
    }

    @Test
    public void testNewArraivalCategory() throws IOException {
        final HttpResponse response = prepareResponse("rss_science.txt");

        final DefaultHttpClient dhc = mock(DefaultHttpClient.class);
        when(dhc.execute(Mockito.any(HttpUriRequest.class))).thenReturn(response);
        when(dhc.getParams()).thenReturn(new BasicHttpParams());

        final NicoHttpClient client = new NicoHttpClient(dhc);

        String page = "http://www.nicovideo.jp/tag/科学?sort=f&rss=2.0";
        List<NicoContent> contents = client.getContentsFromRss(page);

        assertEquals(32, contents.size());
    }
}
