﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using lib2ch.Data;

namespace cs2ch
{
    class ListViewEx : ListView
    {
        ColumnHeader header;
        public ListViewEx()
        {
            header = new ColumnHeader();
            header.Name = "Title";
            header.Text = "タイトル";
            this.Columns.Add(header);
            this.View = View.Details;
            this.Dock = DockStyle.Fill;
            this.AutoArrange = true;
            this.SizeChanged += new EventHandler(ListViewEx_SizeChanged);
            this.AutoResizeColumns(ColumnHeaderAutoResizeStyle.HeaderSize);
        }
        void ListViewEx_SizeChanged(object sender, EventArgs e)
        {
            header.Width = this.ClientSize.Width;
        }
        public void ItemSet(SubjectList SubjectList)
        {
            ListViewItem[] Item = new ListViewItem[SubjectList.List.Count];
            for (int i = 0; i < SubjectList.List.Count; i++)
            {
                Item[i] = new ListViewItem(SubjectList.List[i].Title);
                Item[i].Tag = SubjectList.List[i];
            }
            this.Items.AddRange(Item);
            this.Tag = SubjectList;
        }
    }
}
