// -*-Mode: C++;-*-
//
//  Solid RGBA color class
//
// $Id: Color.hpp,v 1.9 2009/09/21 17:30:40 rishitani Exp $

#ifndef GFX_COLOR_HPP_INCLUDE_
#define GFX_COLOR_HPP_INCLUDE_

#include "gfx.hpp"
#include "AbstractColor.hpp"

using qlib::LString;

namespace qlib {
  class Vector4D;
}

namespace gfx {

  MB_DECL_EXCPT_CLASS(UnknownColorNameException, qlib::RuntimeException);

  /**
     Solid RGBA color class
  */
  class GFX_API SolidColor : public AbstractColor
  {
    MC_SCRIPTABLE;
    MC_CLONEABLE;

  private:
    unsigned int m_code;
    LString m_name;
    int m_nMode;

  public:
    enum {
      CM_RGB,
      CM_HSB,
      CM_CMYK,
      CM_NAMED
    };

  public:
    SolidColor();
    SolidColor(const SolidColor &r);

    SolidColor(unsigned int c);
    SolidColor(int r, int g, int b);
    SolidColor(int r, int g, int b, int a);
    SolidColor(double r, double g, double b);
    SolidColor(double r, double g, double b, double a);
    SolidColor(const qlib::Vector4D &v);
    SolidColor(const LString &name);

    virtual ~SolidColor();
    
    /// = operator
    const SolidColor &operator=(const SolidColor &r);

    ///////////////////////////
    // Common access interfaces

    virtual int r() const;
    virtual int g() const;
    virtual int b() const;
    virtual int a() const;

    virtual unsigned int getCode() const;
    
    virtual bool equals(const AbstractColor &c) const;
    
    ///////////////////////////

    void setCode(unsigned int);
    void setR(int r);
    void setG(int r);
    void setB(int r);
    void setA(int r);

    ///////////////////////////

    static qlib::LScrSp<SolidColor> createRGB(double R, double G, double B, double A=1.0);

    static unsigned int makeRGBACode(int r, int g, int b, int a) {
      return (((a & 0xFF) << 24) |
	      ((r & 0xFF) << 16) |
	      ((g & 0xFF) << 8)  |
	      ((b & 0xFF) << 0));
    }
    
    static int getRCode(unsigned int color) {
      return (color >> 16) & 0xFF;
    }
    static int getGCode(unsigned int color) {
      return (color >> 8) & 0xFF;
    }
    static int getBCode(unsigned int color) {
      return (color >> 0) & 0xFF;
    }
    static int getACode(unsigned int color) {
      return (color >> 24) & 0xff;
    }

    ////////////

    virtual bool isStrConv() const;
    virtual bool fromString(const LString &src);
    virtual LString toString() const;

  };

  typedef SolidColor Color;
}

#endif // GFX_COLOR_HPP_INCLUDE_
