// -*-Mode: C++;-*-
//
//  Generic Hittest class
//
//  $Id: Hittest.hpp,v 1.3 2011/01/09 15:12:22 rishitani Exp $

#ifndef GFX_HIT_TEST_HPP_
#define GFX_HIT_TEST_HPP_

#include "gfx.hpp"

namespace gfx {

///
///  Raw hittest data class.
///  Interpretation of the raw hittest data 
///  depends on the renderer class, by which hittest was performed.
///  Implementation of RawHitData depends on the underlying Gfx implementation.
///
class GFX_API RawHitData {
public:
  virtual ~RawHitData() {}
  //virtual bool getData(int nlevel, int &rval) const =0;
  // virtual void bias(int nshift) const {}

  virtual int getDataSize(qlib::uid_t rend_id) const =0;
  //virtual bool getDataArray(qlib::uid_t rend_id, int *pBuf, int nBufSize) const =0;
  virtual int getDataAt(qlib::uid_t rend_id, int ii, int subii) const =0;
};

#if 0
///
///  Hittest super class.
///  This class only handles generic information of hittest,
///  i.e. object name, renderer ID, and several pure virtual methods.
///  More specific information should be handled in the derivative classes.
///
class GFX_API Hittest {
private:
  /** hit object's uid */
  qlib::uid_t m_nObjID;

  /** hit renderer's uid */
  qlib::uid_t m_nRendID;


public:
  // default constructor
  Hittest() {
    m_nObjID = qlib::invalid_uid;
    m_nRendID = qlib::invalid_uid;
  }

  /** copy constructor */
  Hittest(const Hittest &orig)
       : m_nObjID(orig.m_nObjID), m_nRendID(orig.m_nRendID)
    {
    }

  // destructor
  virtual ~Hittest()
    {
    }

  //
  void setObjID(qlib::uid_t uid) { m_nObjID = uid; }
  qlib::uid_t getObjID() const { return m_nObjID; }

  void setRendID(qlib::uid_t uid) { m_nRendID = uid; }
  qlib::uid_t getRendID() const { return m_nRendID; }

  //virtual bool clicked(const InDevEvent &) const { return true; }
  //virtual bool doubleClicked(const InDevEvent &) const { return true; }

  //virtual void prepareCtxtMenu(ContextMenu *pTarg) const {}
  virtual Hittest *clone() const {
    return new Hittest(*this);
  }
};
#endif

} // namespace gfx

#endif
