// -*-Mode: C++;-*-
//
//  Nucleic acid renderer class
//
//  $Id: NARenderer.hpp,v 1.2 2009/12/17 06:11:27 rishitani Exp $

#ifndef MOLVIS_NUCLEIC_ACID_RENDERER_HPP
#define MOLVIS_NUCLEIC_ACID_RENDERER_HPP

#include "TubeRenderer.hpp"

namespace molstr {
class MolResidue;
}

namespace molvis {

// Nucleic acid renderer
class NARenderer : public TubeRenderer
{
  MC_SCRIPTABLE;
  MC_CLONEABLE;

private:

  typedef TubeRenderer super_t;

  //
  //  properties
  //
  
  /// width of base sticks
  double m_bondw;
  
  /// nucleic acid rendering type (enum)
  int m_nType;

  /// tube rendering on/off
  bool m_fRendTube;

  /// tesselation level of base tubes
  int m_nBaseDetail;

  //
  //  workarea
  //

  std::set<molstr::MolResidue *> *m_pBpTmp;

public:
  /// nucleic acid rendering mode type ID
  static const int NAREND_BP = 0;
  static const int NAREND_SIMPLE1 = 1;
  static const int NAREND_DETAIL1 = 2;

  ////////////

public:
  NARenderer();
  virtual ~NARenderer();

  // virtual Renderer *create();

  virtual const char *getTypeName() const;

  //////////////////////////////////////////////////////

  virtual void beginRend(DisplayContext *pdl);
  virtual void endRend(DisplayContext *pdl);

  virtual void beginSegment(DisplayContext *pdl, MolResiduePtr pRes);
  virtual void rendResid(DisplayContext *pdl, MolResiduePtr pRes);
  virtual void endSegment(DisplayContext *pdl, MolResiduePtr pRes);

  //virtual void endSegment(DisplayContext *pdl, MolResiduePtr pRes);

  // virtual void display(DisplayContext *pdc);
  // virtual void rendHitResid(DisplayContext *phl, MolResiduePtr pRes);


  ////////////////////////////////////////////
  // property handling

  //virtual void propChanged(qlib::LPropEvent &ev);

  void setBaseSize(double f) { m_bondw = f; }
  double getBaseSize() const { return m_bondw; }

  void setBaseType(int n) { m_nType = n; }
  int getBaseType() const { return m_nType; }

  void setRendTube(bool n) { m_fRendTube = n; }
  bool getRendTube() const { return m_fRendTube; }

  void setBaseDetail(int n) { m_nBaseDetail = n; }
  int getBaseDetail() const { return m_nBaseDetail; }

  ////////////////////////////////////////////
  // property handling
  //virtual bool setPropVec(const char *propname, const Vector3D &value);
  //virtual bool getPropVec(const char *propname, Vector3D &value);
  //virtual bool setPropInt(const char *propname, int value);
  //virtual bool getPropInt(const char *propname, int &value);
///  virtual bool setPropReal(const char *propname, double value);
//  virtual bool getPropReal(const char *propname, double &value);
  
private:
  void rendResidBasePair(DisplayContext *pdl, MolResiduePtr pRes);
  void rendResidSimple1(DisplayContext *pdl, MolResiduePtr pRes);
};

}

#endif
