// -*-Mode: C++;-*-
//
//  Ribbon type2 representation test class
//
//  $Id: Ribbon2Renderer.cpp,v 1.2 2010/11/07 13:10:14 rishitani Exp $

#include <common.h>
#include "molvis.hpp"

#include "Ribbon2Renderer.hpp"
#include "TubeSection.hpp"

#include <modules/molstr/MolCoord.hpp>
#include <modules/molstr/MolChain.hpp>
#include <modules/molstr/MolResidue.hpp>

#include <gfx/GradientColor.hpp>

using namespace molvis;
using namespace molstr;

Ribbon2Renderer::Ribbon2Renderer()
     : super_t(), m_pts(new TubeSection())
{
  super_t::setupParentData("section");
}

Ribbon2Renderer::~Ribbon2Renderer()
{
}

const char *Ribbon2Renderer::getTypeName() const
{
  return "ribbon2";
}


void Ribbon2Renderer::beginRend(DisplayContext *pdl)
{
}

void Ribbon2Renderer::endRend(DisplayContext *pdl)
{
}

//////////

void Ribbon2Renderer::beginSegment(DisplayContext *pdl, MolResiduePtr pRes)
{
  m_resvec.clear();
}

void Ribbon2Renderer::rendResid(DisplayContext *pdl, MolResiduePtr pRes)
{
  m_resvec.push_back(pRes);
}

Vector4D ext_circ_cen(const Vector4D &v1, const Vector4D &v2, const Vector4D &v3)
{
  const Vector4D v21 = v2-v1;
  const Vector4D v32 = v3-v2;
  const Vector4D v13 = v1-v3;

  const double csq = v21.sqlen();
  const double asq = v32.sqlen();
  const double bsq = v13.sqlen();

/*
  //double A = (v2-v1).angle(v3-v1);
  double A = v21.angle(-v13);
  //double B = (v3-v2).angle(v1-v2);
  double B = v32.angle(-v21);
  //double C = (v1-v3).angle(v2-v3);
  double C = v13.angle(-v32);

  double sin2A = ::sin(2.0*A);
  double sin2B = ::sin(2.0*B);
  double sin2C = ::sin(2.0*C);
*/
  // (sin2A, sin2B, sin2C) is circumcenter in barycentric coordinate system
  double sin2A = asq*(-asq+bsq+csq);
  double sin2B = bsq*( asq-bsq+csq);
  double sin2C = csq*( asq+bsq-csq);

  double sum = sin2A+sin2B+sin2C;

  // convert barycentric to orthogonal coordinate system
  Vector4D circ = v1.scale(sin2A/sum) + v2.scale(sin2B/sum) + v3.scale(sin2C/sum);
  return circ;
}

void calc_cylcen(const Vector4D &p1, const Vector4D &p2, const Vector4D &p3, const Vector4D &p4,
                     Vector4D &rCen, Vector4D &rNorm, Vector4D *pNorm2 = NULL)
{
  Vector4D v1 = p2-p1;
  Vector4D v2 = p3-p2;
  Vector4D v3 = p4-p3;

  Vector4D circ = ext_circ_cen(v1, v2, v3);

  Vector4D e1 = circ.normalize();
  Vector4D e2;
  
  e2 = e1.cross(Vector4D(1.0, 0.0, 0.0));
  if (qlib::isNear4(e2.sqlen(), 0.0)) {
    e2 = e1.cross(Vector4D(0.0, 1.0, 0.0));
    if (qlib::isNear4(e2.sqlen(), 0.0)) {
      e2 = e1.cross(Vector4D(0.0, 0.0, 1.0));
    }
  }
  e2 = e2.normalize();
  Matrix4D invmat = Matrix4D::makeRotMat(e1, e2);
  Matrix4D mat = invmat.transpose();

  /*
  pdl->sphere(0.1, p1);
  pdl->sphere(0.1, p1+v1);
  pdl->sphere(0.1, p1+v2);
  pdl->sphere(0.1, p1+v3);
   */
  // pdl->sphere(0.15, p1+circ);

  //Vector4D pp1 = mat.mulvec(p1);
  Vector4D pp2 = mat.mulvec(p2-p1);
  Vector4D pp3 = mat.mulvec(p3-p1);
  //pp1.z() = 0.0;
  pp2.z() = 0.0;
  pp3.z() = 0.0;

  Vector4D circ2 = ext_circ_cen(p1, p1+invmat.mulvec(pp2), p1+invmat.mulvec(pp3));

  //pdl->sphere(0.1, p1);
  //pdl->sphere(0.1, p1+invmat.mulvec(pp2));
  //pdl->sphere(0.1, p1+invmat.mulvec(pp3));

  //pdl->sphere(0.15, circ2);

  //pdl->setLighting(true);
  //pdl->cylinder(0.15, circ2, circ2+e1.scale(5.0));
  //pdl->setLighting(false);

  rCen = circ2;
  rNorm = e1;
  if (pNorm2!=NULL)
    *pNorm2 = e2;
}
/*
void Ribbon2Renderer::endSegment(DisplayContext *pdl, MolResiduePtr pEndRes)
{
  int nsize = m_resvec.size();

  int i, j;
  std::vector<Vector4D> vecs(nsize);
  for (i=0; i<nsize; ++i) {
    MolResiduePtr pRes = m_resvec.at(i);
    if (pRes.isnull()) continue;
    MolAtomPtr pAtom = pRes->getPivotAtom();
    if (pAtom.isnull()) continue;
    vecs[i] = pAtom->getPos();
  }  

  if (nsize<4)
    return;

  Vector4D cen1 = calc_cylcen(pdl, vecs.at(0), vecs.at(1), vecs.at(2), vecs.at(3));
  Vector4D cen2 = calc_cylcen(pdl, vecs.at(nsize-1), vecs.at(nsize-2), vecs.at(nsize-3), vecs.at(nsize-4));

  pdl->setLighting(true);
  pdl->color(ColSchmHolder::getDefaultColor());
  pdl->cylinderCap(m_dRadius, cen1, cen2);
  pdl->setLighting(false);

  return;
}
*/

void Ribbon2Renderer::endSegment(DisplayContext *pdl, MolResiduePtr pEndRes)
{
  int nsize = m_resvec.size();

  int i, j;
  std::vector<Vector4D> vecs(nsize);
  for (i=0; i<nsize; ++i) {
    MolResiduePtr pRes = m_resvec.at(i);
    if (pRes.isnull()) continue;
    MolAtomPtr pAtom = pRes->getPivotAtom();
    if (pAtom.isnull()) continue;
    vecs[i] = pAtom->getPos();
  }  

  if (nsize<5)
    return;

  int nsz2 = nsize-4;

  CubicSpline cbs, cbsnorm;
  cbs.setSize(nsize);
  cbsnorm.setSize(nsize);

  Vector4D cen, norm, e2;
  for (i=0; i<=nsz2; ++i) {
    if (i==0)
      calc_cylcen(vecs.at(i+0), vecs.at(i+1), vecs.at(i+2), vecs.at(i+3),
                  cen, norm, &e2);
    else
      calc_cylcen(vecs.at(i+0), vecs.at(i+1), vecs.at(i+2), vecs.at(i+3),
                  cen, norm);
    cbs.setPoint(i, cen);
    cbsnorm.setPoint(i, norm);
  }

  for (i=nsz2+1; i<nsize; ++i) {
    calc_cylcen(vecs.at(i), vecs.at(i-1), vecs.at(i-2), vecs.at(i-3),
                cen, norm);
    cbs.setPoint(i, cen);
    cbsnorm.setPoint(i, -norm);
  }

  /*
  for (i=0; i<nsize; ++i) {
    pdl->sphere(0.1, cens.at(i));
  }
   */

  if (!cbs.generate()) {
    MB_DPRINTLN("CbS generate failed!!");
    return;
  }
  if (!cbsnorm.generate()) {
    MB_DPRINTLN("CbS norm generate failed!!");
    return;
  }

  //////////

  pdl->setLighting(true);
  // pdl->startLineStrip();

  pdl->color(ColSchmHolder::getDefaultColor());

  const int ndiv = 10;
  const double fmax = double(nsize-1);

  Vector4D e3;
  Vector4D e2_prev, e3_prev, cen_prev;
  Vector4D g1, g2, dg1, dg2;

  for (i=0;; ++i) {
    double f = double(i)/double(ndiv);
    if (f>fmax)
      break;
    if (!cbs.interpolate(f, &cen, &norm))
      continue;
    //if (!cbsnorm.interpolate(f, &norm))
    //continue;
    norm = norm.normalize();

    e2 = e2 + norm.scale(-norm.dot(e2));
    e2 = e2.normalize();
    e3 = e2.cross(norm);

    if (i>0) {
      pdl->startTriangleStrip();
      
      for (j=0; j<=m_pts->getSize(); j++) {
        g1 = m_pts->getVec(j, e2, e3);
        g2 = m_pts->getVec(j, e2_prev, e3_prev);
        dg1 = m_pts->getNormVec(j, e2, e3);
        dg2 = m_pts->getNormVec(j, e2_prev, e3_prev);
        pdl->normal(dg2);
        //if (isSmoothColor())
        //pdl->color(pPrevCol);
        pdl->vertex(cen_prev+g2);
        pdl->normal(dg1);
        //pdl->color(pCol);
        pdl->vertex(cen+g1);
        
      }
      
      pdl->end();
    }
    
    e2_prev = e2;
    e3_prev = e3;
    cen_prev = cen;

    if (i%ndiv==0) {
      pdl->sphere(0.1, cen);
      /*
      pdl->vertex(pos+e2);
      pdl->vertex(pos);
      pdl->vertex(pos+e3);
      pdl->vertex(pos);
       */
    }

  }

  pdl->end();
  pdl->setLighting(false);

/*

  const int naver = m_nAver;
  if (nsize<naver)
    return;

    int nsz2 = nsize-naver+1;
  std::vector<Vector4D> aver(nsz2);
  Vector4D sum;
  for (i=0; i<nsz2; ++i) {
    sum.zero();
    for (j=0; j<naver; ++j) {
      MolResiduePtr pRes = m_resvec.at(i+j);
      if (pRes.isnull()) continue;
      MolAtomPtr pAtom = pRes->getPivotAtom();
      if (pAtom.isnull()) continue;
      sum += pAtom->getPos();
    }

    if (naver>0)
      aver[i] = sum.divide(naver);
    else
      aver[i] = Vector4D();
  }

  CubicSpline cbs;
  cbs.setSize(nsz2);
  for (i=0; i<nsz2; ++i)
    cbs.setPoint(i, aver[i]);
  if (!cbs.generate()) {
    MB_DPRINTLN("CbS generate failed!!");
    return;
  }
 */  
}

/*
void Ribbon2Renderer::renderSpline(DisplayContext *pdl, CubicSpline *pCoeff,
                                   MolResiduePtr pStartRes, double fstart,
                                   MolResiduePtr pEndRes, double fend)
{
  // Calculate num of drawing points "ndelta"
  const int naxdet = getAxialDetail();
  int ndelta = (int) ::floor( (fend-fstart)* naxdet );
  if (ndelta<=0) {
    // degenerated (single point)
    // TO DO: impl
    return;
  }

  pdl->setLighting(true);
  pdl->setPolygonMode(DisplayContext::POLY_FILL);
  // glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

  // ???
  // pdl->color(pCol);

  // Declare Vector variables used in the loop
  Vector4D bnorm, vpt, e11, e12, e21, e22, f1, f2;
  Vector4D prev_bnorm, prev_e1, prev_e2, prev_f;
  Vector4D g1, g2, dg1, dg2;

  // Color objects used in the loop
  ColorPtr pCol, pPrevCol;

  // Main loop for each drawing point
  //  i: drawing point index from 0 to ndelta
  //  par: spline coeffcient parameter (from fstart to fend)

  int i, j;
  for (i=0; i<=ndelta; i++) {
    double par = fstart + double(i)/double( naxdet );

    pCol = calcColor(par, pCoeff);

    pCoeff->interpNormal(par, &bnorm);
    pCoeff->interpAxis(par, &f1, &vpt);

    e12 = (bnorm - f1);
    e11 = ( e12.cross(vpt) ).normalize();

    e21 = prev_e1, e22 = prev_e2, f2 = prev_f;

    if (i==0) {
      // Starting point of the segment:
      prev_e1 = e11;
      prev_e2 = e12;
      prev_f = f1;
      pPrevCol = pCol;

      // make the tube cap.
      pdl->color(pCol);
      makeCap(pdl, true, getStartCapType(), m_pts.get(), f1, vpt, e11, e12);

      continue;
    }

    if ((e11.isZero() || e12.isZero()) &&
        (!e21.isZero() && !e22.isZero())) {
      e11 = e21;
      e12 = e22;
    }
    else if ((e21.isZero() || e22.isZero()) &&
             (!e11.isZero() && !e12.isZero())) {
      e21 = e11;
      e22 = e12;
    }

    //
    // Render tube body
    //

    pdl->startTriangleStrip();

    for (j=0; j<=m_pts->getSize(); j++) {
      g1 = m_pts->getVec(j, e11, e12);
      g2 = m_pts->getVec(j, e21, e22);
      dg1 = m_pts->getNormVec(j, e11, e12);
      dg2 = m_pts->getNormVec(j, e21, e22);
      pdl->normal(dg1);
      pdl->color(pCol);
      pdl->vertex(f1+g1);

      pdl->normal(dg2);
      if (isSmoothColor())
        pdl->color(pPrevCol);
      pdl->vertex(f2+g2);
    }

    pdl->end();

    // Post processing
    if (i==ndelta) {
      // make cap at the end point.
      pdl->color(pCol);
      makeCap(pdl, false, getEndCapType(), m_pts.get(), f1, vpt, e11, e12);
    }

    prev_e1 = e11;
    prev_e2 = e12;
    prev_f = f1;
    pPrevCol = pCol;
  }
  
  pdl->setLighting(false);

}
*/

//////////////////////////////////////////////////

//virtual
void Ribbon2Renderer::setAxialDetail(int nlev)
{
  m_nAxialDetail = nlev;
  invalidateSplineCoeffs();
}

void Ribbon2Renderer::propChanged(qlib::LPropEvent &ev)
{
  if (ev.getParentName().equals("coloring")||
      ev.getParentName().startsWith("coloring.")) {
    invalidateDisplayCache();
  }
  else if (ev.getName().equals("radius")) {
    invalidateDisplayCache();
  }
  
  super_t::propChanged(ev);
}

void Ribbon2Renderer::objectChanged(qsys::ObjectEvent &ev)
{
  if (ev.getType()==qsys::ObjectEvent::OBE_CHANGED) {
    invalidateSplineCoeffs();
    invalidateDisplayCache();
    return;
  }
  
  super_t::objectChanged(ev);
}

void Ribbon2Renderer::invalidateSplineCoeffs()
{
  // m_scs.cleanup();
  invalidateDisplayCache();
}

/*
ColorPtr Ribbon2Renderer::calcColor(double par, SplineCoeff *pCoeff)
{
  int nprev = int(::floor(par));
  int nnext = int(::ceil(par));
  double rho = par - double(nprev);

  if (!isSmoothColor()) {
    if (rho>0.5)
      // next
      return ColSchmHolder::getColor(pCoeff->getAtom(nnext));
    else
      // prev
      return ColSchmHolder::getColor(pCoeff->getAtom(nprev));
  }

  // liner interporation of color (nnext, nprev)
  ColorPtr pCol1 = ColSchmHolder::getColor(pCoeff->getAtom(nnext));
  ColorPtr pCol2 = ColSchmHolder::getColor(pCoeff->getAtom(nprev));

  if (pCol1->equals(*pCol2.get()))
    return pCol1;

  ColorPtr pGradCol = ColorPtr(new gfx::GradientColor(pCol1, pCol2, rho));
  return pGradCol;
}
*/

/////////////////////////////////////////////////////////////
// Tube cap rendering routine

void Ribbon2Renderer::makeCap(DisplayContext *pdl,
                           bool fStart, int nType,
                           TubeSection *pTs,
                           const Vector4D &f, const Vector4D &vpt,
                           const Vector4D &e1, const Vector4D &e2)
{
  switch (nType) {
  case 2:
  default:
    // no cap (transparent)
    break;

  case 1:
    // Flat cap
    makeFlatCap(pdl, fStart, pTs, f, vpt, e1, e2);
    break;

  case 0:
    // Spherical cap
    makeSpherCap(pdl, fStart, pTs, f, vpt, e1, e2);
    break;
  }
}

void Ribbon2Renderer::makeFlatCap(DisplayContext *pdl,
                               bool fStart,
                               TubeSection *pTs,
                               const Vector4D &f, const Vector4D &vpt,
                               const Vector4D &e1, const Vector4D &e2)
{
  int j;

  pdl->startTriangleFan();
  // pdl->color(col);
  if (fStart)
    pdl->normal(-vpt);
  else
    pdl->normal(vpt);
  
  pdl->vertex(f);
  // Vector4D prev_g2;

  if (!fStart) {
    for (j=0; j<=pTs->getSize(); j++) {
      Vector4D g2 = pTs->getVec(j, e1, e2);
      pdl->vertex(f+g2);
    }
  }
  else {
    for (j=pTs->getSize(); j>=0; j--) {
      Vector4D g2 = pTs->getVec(j, e1, e2);
      pdl->vertex(f+g2);
    }
  }
  pdl->end();
}

void Ribbon2Renderer::makeSpherCap(DisplayContext *pdl,
                                bool fStart,
                                TubeSection *pTs,
                                const Vector4D &f, const Vector4D &vpt,
                                const Vector4D &e1, const Vector4D &e2)
{
  int i,j;

  const int detail = 5;
  double sign, e1len = pTs->getVec(0, e1, e2).length();
  sign = (fStart) ? -1.0 : 1.0;
  
  Vector4D v = vpt.scale(1.0/vpt.length());
  v = v.scale(sign*e1len/double(detail));
  
  double gpar2, t2;
  Vector4D f2, e21, e22;
  
  //  int stab_sz =
  for (i=0; i<=detail; i++) {
    double t = double(i)/double(detail);
    double gpar = ::sqrt(1.0-t*t);
    //double dgp = -t/gpar;
    Vector4D f1 = f+v.scale(double(i));
    Vector4D e11 = e1.scale(gpar);
    Vector4D e12 = e2.scale(gpar);
    
    if (i==0) {
      t2 = t;
      gpar2 = gpar;
      f2 = f1;
      e21 = e11;
      e22 = e12;
      continue;
    }
    
    // render tube body
    pdl->startTriangleStrip();
    for (j=0; j<=pTs->getSize(); j++) {
      Vector4D stab = pTs->getSectTab(j);
      
      Vector4D g1 = e11.scale(stab.x()) + e12.scale(stab.y());
      Vector4D dg1 = e11.scale(stab.z()) + e12.scale(stab.w());
      Vector4D dgp1 = e11.scale(-stab.w()) + e12.scale(stab.z());
      if (i==detail)
        dg1 = v;
      else
        dg1 = dg1.scale(e1len*gpar) - (dgp1.cross(g1)).scale(t*sign);
      
      Vector4D g2 = e21.scale(stab.x()) + e22.scale(stab.y());
      Vector4D dg2 = e21.scale(stab.z()) + e22.scale(stab.w());
      Vector4D dgp2 = e21.scale(-stab.w()) + e22.scale(stab.z());
      dg2 = dg2.scale(e1len*gpar2) - (dgp2.cross(g2)).scale(t2*sign);
      
      // pdl->color(col);
      if (fStart) {
        pdl->normal(dg2);
        pdl->vertex(f2+g2);
        pdl->normal(dg1);
        pdl->vertex(f1+g1);
      }
      else {
        pdl->normal(dg1);
        pdl->vertex(f1+g1);
        pdl->normal(dg2);
        pdl->vertex(f2+g2);
        }
    }
    
    pdl->end();
    t2 = t;
    gpar2 = gpar;
      f2 = f1;
    e21 = e11;
    e22 = e12;
    
  }
}



