// -*-Mode: C++;-*-
//
//  Ribbon type2 representation (test)
//

#ifndef RIBBON2_RENDERER_HPP_INCLUDED
#define RIBBON2_RENDERER_HPP_INCLUDED

#include "molvis.hpp"

#include <qlib/Vector4D.hpp>
#include <modules/molstr/MainChainRenderer.hpp>
#include "CubicSpline.hpp"
#include "SplineCoeffSet.hpp"
#include "TubeSection.hpp"

class Ribbon2Renderer_wrap;

namespace molvis {

using qlib::Vector4D;
using gfx::ColorPtr;
using namespace molstr;

class TubeSection;

class Ribbon2Renderer : public MainChainRenderer
{
  MC_SCRIPTABLE;
  MC_CLONEABLE;

  friend class ::Ribbon2Renderer_wrap;

private:

  typedef MainChainRenderer super_t;

  /// Num of interporation point to the axial direction (axialdetail)
  int m_nAxialDetail;

  /// interpolate color or not
  bool m_bInterpColor;

  double m_dRadius;

  /// Section data
  TubeSectionPtr m_pts;

  ////////////

  std::deque<MolResiduePtr> m_resvec;

public:
  Ribbon2Renderer();
  virtual ~Ribbon2Renderer();

  virtual const char *getTypeName() const;

  //////////////////////////////////////////////////////

  virtual void beginRend(DisplayContext *pdl);
  virtual void endRend(DisplayContext *pdl);

  virtual void beginSegment(DisplayContext *pdl, MolResiduePtr pRes);
  virtual void rendResid(DisplayContext *pdl, MolResiduePtr pRes);
  virtual void endSegment(DisplayContext *pdl, MolResiduePtr pRes);

  //////////////////////////////////////////////////////


  //////////////////////////////////////////////////////
  // event handling

  virtual void propChanged(qlib::LPropEvent &ev);

  virtual void objectChanged(qsys::ObjectEvent &ev);

  //////////////////////////////////////////////////////

  virtual void setAxialDetail(int nlev);

  int getAxialDetail() const { return m_nAxialDetail; }

  void setSmoothColor(bool b) {
    invalidateDisplayCache();
    m_bInterpColor = b;
  }
  bool isSmoothColor() const { return m_bInterpColor; }

  // ColorPtr calcColor(double par, SplineCoeff *pCoeff);

  void invalidateSplineCoeffs();

  //////////////////////////////////////////////////////
  // Tube capping routine

public:
  /// cap type ID
  enum {
    TUBE_CAP_SPHR = 0,
    TUBE_CAP_FLAT = 1,
    TUBE_CAP_NONE = 2
  };

  int getStartCapType() const { return m_nStCapType; }
  void setStartCapType(int nType) {
    super_t::invalidateDisplayCache();
    m_nStCapType = nType;
  }

  int getEndCapType() const { return m_nEnCapType; }
  void setEndCapType(int nType) {
    super_t::invalidateDisplayCache();
    m_nEnCapType = nType;
  }

private:

  /// start cap type
  int m_nStCapType;
  int m_nEnCapType;

public:
  
  void makeSpherCap(DisplayContext *pdl,
                    bool fStart,
                    TubeSection *pTs,
                    const Vector4D &f, const Vector4D &vpt,
                    const Vector4D &e1, const Vector4D &e2);

  void makeFlatCap(DisplayContext *pdl,
                   bool fStart,
                   TubeSection *pTs,
                   const Vector4D &f, const Vector4D &vpt,
                   const Vector4D &e1, const Vector4D &e2);

  void makeCap(DisplayContext *pdl,
               bool fStart, int nType,
               TubeSection *pTs,
               const Vector4D &f, const Vector4D &vpt,
               const Vector4D &e1, const Vector4D &e2);


  TubeSectionPtr getTubeSection() const {
    return m_pts;
  }


};

}

#endif
