// -*-Mode: C++;-*-
//
//  Backbone spline-trace renderer class
//
//  $Id: TubeRenderer.cpp,v 1.10 2010/11/03 11:34:20 rishitani Exp $

#include <common.h>

#include "TubeRenderer.hpp"

#include <modules/molstr/MolCoord.hpp>
#include <modules/molstr/MolChain.hpp>
#include <modules/molstr/MolResidue.hpp>

//#include <molstr/ResiToppar.hpp>
//#include <molstr/ResiLink.hpp>

using namespace molvis;
using namespace molstr;

TubeRenderer::TubeRenderer()
     : SplineRenderer(), m_pts(new TubeSection())
{
  super_t::setupParentData("section");
  //resetAllProps();
}

TubeRenderer::~TubeRenderer()
{
}

const char *TubeRenderer::getTypeName() const
{
  return "tube";
}

/////////////////////////////////////////////////////

void TubeRenderer::beginRend(DisplayContext *pdl)
{
  if (!m_pts->isValid())
    m_pts->setupSectionTable();

  super_t::beginRend(pdl);
}

/////////////////////////////////////////////////////

//virtual
void TubeRenderer::renderSpline(DisplayContext *pdl, SplineCoeff *pCoeff,
                                MolResiduePtr pStartRes, double fstart,
                                MolResiduePtr pEndRes, double fend)
{
  // Calculate num of drawing points "ndelta"
  const int naxdet = getAxialDetail();
  int ndelta = (int) ::floor( (fend-fstart)* naxdet );
  if (ndelta<=0) {
    // degenerated (single point)
    // TO DO: impl
    return;
  }

  pdl->setLighting(true);
  pdl->setPolygonMode(DisplayContext::POLY_FILL);
  // glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

  // ???
  // pdl->color(pCol);

  // Declare Vector variables used in the loop
  Vector4D bnorm, vpt, e11, e12, e21, e22, f1, f2;
  Vector4D prev_bnorm, prev_e1, prev_e2, prev_f;
  Vector4D g1, g2, dg1, dg2;

  // Color objects used in the loop
  ColorPtr pCol, pPrevCol;

  // Main loop for each drawing point
  //  i: drawing point index from 0 to ndelta
  //  par: spline coeffcient parameter (from fstart to fend)

  int i, j;
  for (i=0; i<=ndelta; i++) {
    double par = fstart + double(i)/double( naxdet );

    pCol = calcColor(par, pCoeff);

    pCoeff->interpNormal(par, &bnorm);
    pCoeff->interpAxis(par, &f1, &vpt);

    e12 = (bnorm - f1);
    e11 = ( e12.cross(vpt) ).normalize();

    e21 = prev_e1, e22 = prev_e2, f2 = prev_f;

    if (i==0) {
      // Starting point of the segment:
      prev_e1 = e11;
      prev_e2 = e12;
      prev_f = f1;
      pPrevCol = pCol;

      // make the tube cap.
      pdl->color(pCol);
      makeCap(pdl, true, getStartCapType(), m_pts.get(), f1, vpt, e11, e12);

      continue;
    }

    if ((e11.isZero() || e12.isZero()) &&
        (!e21.isZero() && !e22.isZero())) {
      e11 = e21;
      e12 = e22;
    }
    else if ((e21.isZero() || e22.isZero()) &&
             (!e11.isZero() && !e12.isZero())) {
      e21 = e11;
      e22 = e12;
    }

    //
    // Render tube body
    //

    pdl->startTriangleStrip();

    for (j=0; j<=m_pts->getSize(); j++) {
      g1 = m_pts->getVec(j, e11, e12);
      g2 = m_pts->getVec(j, e21, e22);
      dg1 = m_pts->getNormVec(j, e11, e12);
      dg2 = m_pts->getNormVec(j, e21, e22);
      pdl->normal(dg1);
      pdl->color(pCol);
      pdl->vertex(f1+g1);

      pdl->normal(dg2);
      if (isSmoothColor())
        pdl->color(pPrevCol);
      pdl->vertex(f2+g2);
    }

    pdl->end();

    // Post processing
    if (i==ndelta) {
      // make cap at the end point.
      pdl->color(pCol);
      makeCap(pdl, false, getEndCapType(), m_pts.get(), f1, vpt, e11, e12);
    }

    prev_e1 = e11;
    prev_e2 = e12;
    prev_f = f1;
    pPrevCol = pCol;
  }
  
  pdl->setLighting(false);

}

void TubeRenderer::propChanged(qlib::LPropEvent &ev)
{
  if (ev.getParentName().equals("section")||
      ev.getParentName().startsWith("section.")) {
    invalidateDisplayCache();
  }

  super_t::propChanged(ev);
}

