//
// Crystallographic visualization module
//  module loader/common impl
//
// $Id: xtal.cpp,v 1.3 2011/01/03 16:47:05 rishitani Exp $
//

#include <common.h>

#include "xtal.hpp"
#include "MapMeshRenderer.hpp"
#include "CCP4MapReader.hpp"
#include "MTZ2MapReader.hpp"

extern void xtal_regClasses();
extern void xtal_unregClasses();

#include <qsys/RendererFactory.hpp>
using qsys::RendererFactory;

#include <qsys/StreamManager.hpp>
using qsys::StreamManager;

namespace xtal {

bool init()
{
  xtal_regClasses();
  CCP4MapReader::regClass();
  
  RendererFactory *pRF = RendererFactory::getInstance();
  pRF->regist<MapMeshRenderer>();

  StreamManager *pSM = StreamManager::getInstance();
  pSM->registReader<CCP4MapReader>();
  pSM->registReader<MTZ2MapReader>();

  MB_DPRINTLN("xtal init: OK");
  return true;
}

void fini()
{
  // PDBFileReader::unregClass();
  // xtal_unregClasses();
  
  MB_DPRINTLN("xtal fini: OK");
}

}
