#!/usr/bin/perl

my $arch = "MacOSX-Intel";
my $inst_top = $ARGV[0];
my $top_srcdir = $ARGV[1];
my $boost_dir = $ARGV[2];

if (!-d $inst_top) {
    die "inst_top ($inst_top) not found.\nUsage: $0 <inst_top> <top_srcdir> [boost_dir]\n";
}
if (!-d $top_srcdir) {
    die "top_srcdir ($top_srcdir) not found.\nUsage: $0 <inst_top> <top_srcdir> [boost_dir]\n";
}

# print "boost_dir $boost_dir\n";
$boost_dir =~ s/^-L//;
if (!-d $boost_dir) {
    print "$boost_dir not found, use /usr/local instead ...\n";
    $boost_dir = "/usr/local/lib"
}
else {
    print "boost_dir $boost_dir\n";
}

my $XUL_FRAMEWORK="/Library/Frameworks/XUL.framework";
#my @lib_list = ("libqlib", "libqsys", "libgfx", "libmolstr", "libmolvis");

my @lib_list = ("libqlib", "libqsys", "libgfx", "libjsbr",
		"libmolstr", "libmolvis", "libsymm", "libsurface", "libxtal", "libmolanl",
		"libboost_thread", "libboost_system", "libboost_filesystem", "libboost_iostreams");

my @copylib = ("$boost_dir/libboost_thread*.dylib",
	       "$boost_dir/libboost_system*.dylib",
	       "$boost_dir/libboost_filesystem*.dylib",
	       "$boost_dir/libboost_iostreams*.dylib");
my $RSYNC = "rsync";

my $dist_top; 
open(IN, "$top_srcdir/version.hpp") || die "$?:$!";
while (<IN>) {
    if (/PRODUCTVER\s+(\d+),(\d+),(\d+),(\d+)/) {
	$dist_top = "CueMol2-$1.$2.$3.$4-$arch"; 
    }
}
close(IN);

print "output: $dist_top\n";

#####
if (1) {
if (-d $dist_top) {
    system("rm -rf $dist_top");
}

system("$RSYNC -v -a --copy-unsafe-links ".
       "--cvs-exclude ".
       "--exclude Frameworks ".
       "--exclude run_win.bat ".
       "--exclude chrome.manifest ".
       "--exclude chrome/content/ ".
       "--exclude chrome/locale/ ".
       "--exclude defaults/preferences/debug-prefs.js ".
       "--exclude jarmaker/ ".
       "--exclude \"Makefile*\" ".
       "--exclude \"*.la\" ".
       "$inst_top $dist_top");

system("$RSYNC -v -a --copy-unsafe-links ".
       "$XUL_FRAMEWORK $dist_top/CueMol2.app/Contents/Frameworks/");
if ($?) {
    print("result=<$?>\n");
    die "rsync failed.";
}
#exit;
}

#####

foreach my $libf (@copylib) {
    system("install $libf $dist_top/CueMol2.app/Contents/Resources/lib/");
    if ($?) {
	print("result=<$?>\n");
	die "install failed.";
    }
}

#####

#open(IN, "find -L $dist_top/CueMol2.app/Contents/Resources -name \"*.dylib\" -print |") || die "$!:$?";
open(IN, "find $dist_top/CueMol2.app/Contents/Resources -perm 0755 -type f -print |") || die "$!:$?";

while (<IN>) {
    chomp;
    my $otfile = $_;
    # print ("======= $_ ======\n");
    open(IN2, "otool -L $otfile |") || die "$?:$!";
    while (<IN2>) {
	my $dylib = $otfile;
	chomp;
	unless (/(\S+)\s+\(/) {
	    next;
	}
	my $deplib_path = $1;
	unless (match_lib($deplib_path)) {
	    next;
	}
	my $deplib_fname = base_name($deplib_path);
	$deplib_fname = "\@executable_path/../Resources/lib/$deplib_fname";
	# print "ChangeInstName: $dylib\n   $deplib_path --> $deplib_fname\n";

	change_instname($dylib, $deplib_path, $deplib_fname);

	#change_instname($dylib, $deplib_name,
	# "/Users/ishitani/proj/cuemol2/src/xul_gui/lib/$deplib_fname");
    }
}

close(IN);

system("perl $top_srcdir/osxbuild/pkg-dmg --source $dist_top --target $dist_top.dmg"); 

sub match_lib($) {
    my $fname = shift;
    foreach my $i (@lib_list) {
	if ($fname =~ /$i/) {
	    return 1;
	}
    }

    return 0;
}

sub base_name($) {
    my $fname = shift;
    if ($fname =~ /([^\/]+)$/) {
	return $1;
    }
}

sub change_instname($$$) {
    my ($dylib, $orignm, $newnm) = @_;

    my $cmd = "install_name_tool -change $orignm $newnm $dylib";
    print("$cmd\n");
    system($cmd);
    if ($?) {
	print("result=<$?>\n");
	die "install_name_tool failed.";
    }
}
