// -*-Mode: C++;-*-
//
// Superclass for object factory classes
//
// $Id: LFactory.cpp,v 1.3 2008/01/13 09:23:19 rishitani Exp $

#include <common.h>
#include "LFactory.hpp"
#include "LDynamic.hpp"
#include "LClass.hpp"
#include "ClassRegistry.hpp"

using namespace qlib;

#if 0
LFactory::~LFactory()
{
  data_t::const_iterator iter = m_data.begin();
  for ( ; iter!=m_data.end(); ++iter) {
    if (iter->second.pCtor!=NULL)
      delete iter->second.pCtor;
  }
}

bool LFactory::insert(const LString &type, const LClass &cls)
{
  LString abiname = cls.getAbiClassName();
  Entry ent(abiname);
  bool res = m_data.insert(data_t::value_type(type, ent)).second;
  return res;
}

bool LFactory::insert(const LString &type, LCreator *pctor)
{
  Entry ent(pctor);
  bool res = m_data.insert(data_t::value_type(type, ent)).second;
  return res;
}

LObject *LFactory::createInstance(const LString &type) const
{
  data_t::const_iterator iter = m_data.find(type);
  if (iter==m_data.end()) {
    MB_DPRINTLN("LFactory::createInst: type %s is not found", type.c_str());
    return NULL;
  }
  const Entry &ent = iter->second;

  if (ent.pCtor==NULL) {
    ClassRegistry *pReg = ClassRegistry::getInstance();
    MB_ASSERT(pReg!=NULL);
    LClass *pCls = pReg->getClassObjByAbiNameNx(ent.abiname);
    if (pCls==NULL) {
      LOG_DPRINTLN("LFactory::createInst: class %s is not found", ent.abiname.c_str());
      return NULL;
    }
    LDynamic *ptmp = pCls->createObj();
    LObject *pret = dynamic_cast<LObject *>(ptmp);
    if (pret!=NULL) {
      MB_DPRINTLN("LFactory object %p(%s) created by LClass.",
		  pret, typeid(*pret).name());
      return pret;
    }

    LOG_DPRINTLN("LFactory::createInst: class %s is not a subclass of LObject", ent.abiname.c_str());
    delete ptmp;
    return NULL;
  }
  else {
    LObject *pret = ent.pCtor->createInstance();
    MB_DPRINTLN("LFactory object %p(%s) created by LCreator.",
		pret, typeid(*pret).name());
    return pret;
  }
}
#endif
