// -*-Mode: C++;-*-
//
// LRegExpr.hpp
//   Regular expression class using PCRE
//
// $Id: LRegExpr.hpp,v 1.6 2009/08/27 08:42:07 rishitani Exp $

#ifndef L_REG_EXPR_HPP_INCLUDED_
#define L_REG_EXPR_HPP_INCLUDED_

#include "qlib.hpp"

#include "LScrObjects.hpp"
#include "LScrSmartPtr.hpp"
#include "LExceptions.hpp"
#include "SmartPtr.hpp"
#include "mcutils.hpp"

namespace qlib {

  MB_DECL_EXCPT_CLASS(InvalidREPatternException, RuntimeException);
  MB_DECL_EXCPT_CLASS(PatternMatchException, RuntimeException);
  MB_DECL_EXCPT_CLASS(SubstrNotFoundException, RuntimeException);

  namespace detail {
    struct ReData {
    public:
      bool m_bicase;
      void *m_pdata;
      void *m_pextra;
      ReData() : m_bicase(false), m_pdata(NULL), m_pextra(NULL) {}
      ~ReData();
    };
  }

  class QLIB_API LRegExpr : public LSimpleCopyScrObject
  {
    MC_SCRIPTABLE;
    MC_CLONEABLE;

    //////////
  public:
    /** pattern string */
    LString m_pat;

    /** subject string */
    LString m_subj;

    //////////
  private:

    /** internal data */
    sp<detail::ReData> m_pdat;

    /** result vector */
    std::vector<int> m_ovector;

    static const int OVECCOUNT=60;

    int m_nSubstr;

  public:
    LRegExpr()
      : m_pdat(), m_ovector(OVECCOUNT), m_nSubstr(0)
    {
    }

    LRegExpr(const LRegExpr &a)
      : m_pat(a.m_pat), m_subj(a.m_subj),
	m_pdat(a.m_pdat), m_ovector(a.m_ovector), m_nSubstr(a.m_nSubstr)
    {
    }

    LRegExpr(int nsize)
      : m_pdat(), m_ovector(nsize), m_nSubstr(0)
    {
    }

    LRegExpr(const LString &pattern)
      : m_pat(pattern), m_pdat(), m_ovector(OVECCOUNT), m_nSubstr(0)
    {
    }


    /** copy operator */
    const LRegExpr &operator=(const LRegExpr &a) {
      if(&a!=this){
	m_pat = (a.m_pat);
	m_subj = (a.m_subj);
	m_pdat = (a.m_pdat);
	m_ovector = (a.m_ovector);
	m_nSubstr = (a.m_nSubstr);
      }
      return *this;
    }
    

    virtual ~LRegExpr();

    void cleanup();

    void setPattern(const LString &pattern) throw (InvalidREPatternException);
    const LString &getPattern() const { return m_pat; }

    bool match(const LString &subj)
      throw (PatternMatchException) {
      return matchImpl(subj, false);
    }

    bool matchIgnoreCase(const LString &subj)
      throw (PatternMatchException) {
      return matchImpl(subj, true);
    }

    int getSubstrCount() const { return m_nSubstr; }
    LString getSubstr(int index);
    LString getNamedSubstr(const LString &name);

    virtual bool isStrConv() const;
    virtual LString toString() const;
    static LRegExpr *fromStringS(const LString &src);

  private:
    bool matchImpl(const LString &pattern, bool bIcase)
      throw (PatternMatchException);
  };

}

#endif // L_REG_EXPR_HPP_INCLUDED_
