// -*-Mode: C++;-*-
//
// Simple array of LVariant
//   This class should be used to arg/retval conversion,
//   and shouldn't be used for data storing!!
//
// $Id: LVarArray.hpp,v 1.4 2010/12/26 12:26:17 rishitani Exp $

#ifndef L_VARIANT_ARRAY_HPP_INCLUDED_
#define L_VARIANT_ARRAY_HPP_INCLUDED_

#include "qlib.hpp"

#include "LScrObjects.hpp"
#include "LVariant.hpp"
#include "LScrSmartPtr.hpp"
#include "mcutils.hpp"

namespace qlib {

  template <typename _ValueType>
  class LArrayTmpl
  {
  private:
    /**
       the size of the array
    */
    int m_nSize;

    /**
       data array
    */
    _ValueType *m_pData;

  public:
    LArrayTmpl()
         : m_nSize(0), m_pData(NULL)
    {
    }

    LArrayTmpl(int nsize)
         : m_nSize(0), m_pData(NULL)
    {
      allocate(nsize);
    }

    LArrayTmpl(const LArrayTmpl &a)
         : m_nSize(0), m_pData(NULL)
    {
      copyFrom(a);
    }

    /** copy operator */
    const LArrayTmpl &operator=(const LArrayTmpl &a)
	{
      if(&a!=this){
        copyFrom(a);
      }
      return *this;
    }

    ~LArrayTmpl()
    {
      destroy();
    }

    //////////

    void destroy()
    {
      if (m_pData!=NULL)
	delete [] m_pData;
      m_pData = NULL;
      m_nSize = 0;
    }

    void allocate(int nsize)
    {
      if (m_pData!=NULL)
        destroy();
      m_pData = new _ValueType[nsize];
      m_nSize = nsize;
    }

    void copyFrom(const LArrayTmpl &a)
    {
      destroy();
      m_nSize = a.m_nSize;
      allocate(a.m_nSize);
      for (int i=0; i<m_nSize; ++i) {
	m_pData[i] = a.m_pData[i];
      }
    }

    int getSize() const { return m_nSize; }

    const _ValueType &get(int n) const {
      MB_ASSERT(0<=n && n<m_nSize);
      if (n<0 || m_nSize<=n)
        MB_THROW(IndexOutOfBoundsException,
                 LString::format("LArrayTmpl get() invalid index %d", n));
      return m_pData[n];
    }

    _ValueType &at(int n) {
      MB_ASSERT(0<=n && n<m_nSize);
      if (n<0 || m_nSize<=n)
        MB_THROW(IndexOutOfBoundsException,
                 LString::format("LArrayTmpl get() invalid index %d", n));
      return m_pData[n];
    }
  };

  ///////////////////////////////////////////////////////////

  ///
  /// Scriptable array of variants
  ///
  class QLIB_API LVarArray : public LArrayTmpl<LVariant>
  {
  public:
    LVarArray()
      : LArrayTmpl<LVariant>()
    {
    }

    LVarArray(int nsize)
      : LArrayTmpl<LVariant>(nsize)
    {
    }

    LVarArray(const LVarArray &a)
      : LArrayTmpl<LVariant>(a)
    {
    }

    // LVariant getValue(int ind) const {
    // return get(ind);
    // }
    // void setValue(int ind, const LVariant &value) {
    // at(ind) = value;
    // }

    //////

    inline bool isNull(int index) const {
      return get(index).isNull();
    }

    inline void setNull(int index) {
      at(index).setNull();
    }

    //////

    inline bool isBool(int index) const {
      return get(index).isBool();
    }

    inline void setBoolValue(int index, LBool b) {
      at(index).setBoolValue(b);
    }

    inline LBool getBoolValue(int index) const {
      return get(index).getBoolValue();
    }

    //////

    inline bool isInt(int index) const {
      return get(index).isInt();
    }

    inline void setIntValue(int index, LInt b) {
      at(index).setIntValue(b);
    }

    inline LInt getIntValue(int index) const {
      return get(index).getIntValue();
    }

    //////

    inline bool isReal(int index) const {
      return get(index).isReal();
    }

    inline void setRealValue(int index, LReal b) {
      at(index).setRealValue(b);
    }

    inline LReal getRealValue(int index) const {
      return get(index).getRealValue();
    }

    //////

    inline bool isString(int index) const {
      return get(index).isString();
    }

    inline void setStringValue(int index, const LString &b) {
      at(index).setStringValue(b);
    }

    inline const LString &getStringValue(int index) const {
      return get(index).getStringValue();
    }

    //////

    inline bool isEnum(int index) const {
      return get(index).isEnum();
    }

    inline void setEnumValue(int index, const LString &b) {
      at(index).setEnumValue(b);
    }

    inline const LString &getEnumValue(int index) const {
      return get(index).getEnumValue();
    }

    //////

    inline bool isObject(int index) const {
      return get(index).isObject();
    }

    inline void setObjectPtr(int index, LScriptable *pObj) {
      at(index).setObjectPtr(pObj);
    }

    inline LScriptable *getObjectPtr(int index) const {
      return get(index).getObjectPtr();
    }

  };

  typedef LScrSp<LVarArray> LVarArrayPtr;

  ///////////////////////////////////////////////////////////////////////////////

#if 0
  ///
  /// Scriptable array of integer
  ///
  class QLIB_API LIntArray : public LSimpleCopyScrObject, public LArrayTmpl<int>
  {
    MC_SCRIPTABLE;
    MC_CLONEABLE;

  public:
    LIntArray()
      : LArrayTmpl<int>()
    {
    }

    LIntArray(int nsize)
      : LArrayTmpl<int>(nsize)
    {
    }

    LIntArray(const LIntArray &a)
      : LArrayTmpl<int>(a)
    {
    }

    int getValue(int ind) const {
      // TO DO: range chk & throw exception
      return get(ind);
    }
    void setValue(int ind, int value) {
      // TO DO: range chk & throw exception
      at(ind) = value;
    }
  };

  typedef LScrSp<LIntArray> LIntArrayPtr;

  ///
  /// Scriptable array of string
  ///
  class QLIB_API LStrArray : public LSimpleCopyScrObject, public LArrayTmpl<LString>
  {
    MC_SCRIPTABLE;
    MC_CLONEABLE;

  public:
    LStrArray()
      : LArrayTmpl<LString>()
    {
    }

    LStrArray(int nsize)
      : LArrayTmpl<LString>(nsize)
    {
    }

    LStrArray(const LStrArray &a)
      : LArrayTmpl<LString>(a)
    {
    }

    LString getValue(int ind) const {
      // TO DO: range chk & throw exception
      return get(ind);
    }
    void setValue(int ind, const LString &value) {
      // TO DO: range chk & throw exception
      at(ind) = value;
    }
  };

  typedef LScrSp<LStrArray> LStrArrayPtr;
#endif
  
}

#endif // L_VARIANT_ARRAY_HPP_INCLUDED_

