// -*-Mode: C++;-*-
//
// POV-Ray scene output class
//

#ifndef POVRAY_SCENE_EXPORTER_HPP_INCLUDED_
#define POVRAY_SCENE_EXPORTER_HPP_INCLUDED_

#include "qsys.hpp"

#include "SceneExporter.hpp"
#include <qlib/mcutils.hpp>

class PovSceneExporter_wrap;

namespace qsys {

class QSYS_API PovSceneExporter : public SceneExporter
{
  MC_SCRIPTABLE;

  friend class ::PovSceneExporter_wrap;

private:
  
  // bool m_bTexBlend;

  bool m_bUseClipZ;

  bool m_bPerspective;

  /// change the inc file path name to relative to pov file
  bool m_bMakeRelIncPath;

  LString m_strIncFileName;

  LString m_cameraName;

public:
  PovSceneExporter();
  virtual ~PovSceneExporter();

  /// write to the stream
  virtual void write();

  /////////////////////////////////

  /// Get name of the writer
  virtual const char *getName() const;

  /// Get file-type description
  virtual const char *getTypeDescr() const;

  /// Get file extension
  virtual const char *getFileExt() const;

};

}

#endif

